/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer;

import csfs.datatransfer.KnownTransferMethodMap;
import csfs.datatransfer.blockingnio.BlockingNIOMethod;
import csfs.datatransfer.blockingnio.BlockingNIOServer;
import csfs.datatransfer.corba.CORBAMethod;
import csfs.datatransfer.corba.SegmentedCORBAMethod;
import csfs.datatransfer.ftp.PureFTPdMethod;
import csfs.datatransfer.nonblockingnio.NonBlockingNIOMethod;
import csfs.datatransfer.nonblockingnio.NonBlockingNIOServer;
import csfs.datatransfer.scp.SCPMethod;
import csfs.datatransfer.streamblockingnio.StreamBlockingNIOMethod;
import csfs.datatransfer.streamblockingnio.StreamBlockingNIOServer;
import csfs.impl.util.SystemProperties;

public class CopyMethodsInitializer {
    public static void initialize(KnownTransferMethodMap methods, String host) {
        methods.addMethod("CORBA", "", new CORBAMethod());
        methods.addMethod("SegmentedCORBA", "", new SegmentedCORBAMethod());
        if ("true".equals(SystemProperties.getProperty("ENABLE_EXTRA_COPY_METHODS"))) {
            int copyServerPriority = Thread.currentThread().getPriority() - 3;
            String rootDir = SystemProperties.getProperty("ROOT_DIR");
            int port = SystemProperties.getIntProperty("PURE_FTP_PORT");
            methods.addMethod("PureFTPd", host + ":" + port, new PureFTPdMethod());
            methods.addMethod("SCP", host, new SCPMethod());
            port = SystemProperties.getIntProperty("NON_BLOCKING_NIO_PORT");
            NonBlockingNIOServer copyServer = new NonBlockingNIOServer(rootDir, port);
            copyServer.setPriority(copyServerPriority);
            methods.addMethod("NON_BLOCKING_NIO", host + ":" + port, new NonBlockingNIOMethod());
            port = SystemProperties.getIntProperty("BLOCKING_NIO_PORT");
            BlockingNIOServer blockingCopyServerDefault = new BlockingNIOServer(rootDir, port, 0);
            blockingCopyServerDefault.setPriority(copyServerPriority);
            methods.addMethod("BLOCKING_NIOxDEFAULT", host + ":" + port, new BlockingNIOMethod());
            port = SystemProperties.getIntProperty("BLOCKING_NIO_SMALL_BUFFER_PORT");
            BlockingNIOServer blockingCopyServerSmallBuffer = new BlockingNIOServer(rootDir, port, SystemProperties.getIntProperty("SMALL_BUFFER_SIZE"));
            blockingCopyServerSmallBuffer.setPriority(copyServerPriority);
            methods.addMethod("BLOCKING_NIOxSMALL_BUFFER", host + ":" + port, new BlockingNIOMethod());
            port = SystemProperties.getIntProperty("BLOCKING_NIO_REGULAR_BUFFER_PORT");
            BlockingNIOServer blockingCopyServerRegularBuffer = new BlockingNIOServer(rootDir, port, SystemProperties.getIntProperty("REGULAR_BUFFER_SIZE"));
            blockingCopyServerRegularBuffer.setPriority(copyServerPriority);
            methods.addMethod("BLOCKING_NIOxREGULAR_BUFFER", host + ":" + port, new BlockingNIOMethod());
            port = SystemProperties.getIntProperty("BLOCKING_NIO_LARGE_BUFFER_PORT");
            BlockingNIOServer blockingCopyServerLargeBuffer = new BlockingNIOServer(rootDir, port, SystemProperties.getIntProperty("LARGE_BUFFER_SIZE"));
            blockingCopyServerLargeBuffer.setPriority(copyServerPriority);
            methods.addMethod("BLOCKING_NIOxLARGE_BUFFER", host + ":" + port, new BlockingNIOMethod());
            port = SystemProperties.getIntProperty("STREAM_BLOCKING_NIO_PORT");
            StreamBlockingNIOServer streamBlockingCopyServer = new StreamBlockingNIOServer(rootDir, port);
            streamBlockingCopyServer.setPriority(copyServerPriority);
            methods.addMethod("STREAM_BLOCKING_NIO", host + ":" + port, new StreamBlockingNIOMethod());
            blockingCopyServerDefault.start();
            blockingCopyServerSmallBuffer.start();
            blockingCopyServerRegularBuffer.start();
            blockingCopyServerLargeBuffer.start();
            streamBlockingCopyServer.start();
            copyServer.start();
        }
    }
}

