/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.corba;

import csfs.datatransfer.corba.SegmentedCORBAManager;
import csfs.remote.RandomAccessChannel;
import java.io.File;
import java.io.RandomAccessFile;

class CopySegment
implements Runnable {
    private long offset;
    private long size;
    private File localFile;
    private RandomAccessChannel destination;
    private int bufferSize;
    private SegmentedCORBAManager parent;

    public CopySegment(SegmentedCORBAManager parent, long offset, long size, File localFile, RandomAccessChannel destination, int bufferSize) {
        this.parent = parent;
        this.offset = offset;
        this.size = size;
        this.localFile = localFile;
        this.destination = destination;
        this.bufferSize = bufferSize;
    }

    @Override
    public void run() {
        Exception exc = null;
        try {
            int localRead;
            byte[] buffer = new byte[this.bufferSize];
            RandomAccessFile file = new RandomAccessFile(this.localFile, "rw");
            file.seek(this.offset);
            this.destination.seek(this.offset);
            int bytesRead = 0;
            for (long read = 0L; read < this.size && bytesRead != -1; read += (long)localRead) {
                localRead = 0;
                do {
                    if ((bytesRead = file.read(buffer, localRead, buffer.length - localRead)) == -1) continue;
                    localRead += bytesRead;
                } while (bytesRead != -1 && localRead != buffer.length);
                this.destination.write(localRead, buffer);
            }
            file.close();
            this.destination.close();
        }
        catch (Exception exc2) {
            exc = exc2;
            exc.printStackTrace();
        }
        this.parent.notifyEnd(exc);
    }
}

