/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl;

import csfs.datatransfer.CopyMethodsInitializer;
import csfs.datatransfer.DataTransferMethod;
import csfs.datatransfer.KnownTransferMethodMap;
import csfs.impl.performancetracker.DataTransferPerformanceTracker;
import csfs.impl.performancetracker.UnavailableInformationException;
import csfs.impl.util.ServerExceptionBuilder;
import csfs.impl.util.SystemProperties;
import csfs.impl.util.Util;
import csfs.remote.FileServerPOA;
import csfs.remote.RemoteFile;
import csfs.remote.RemoteFileHelper;
import csfs.remote.ServerException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.io.FileSystemUtils;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;

public class FileServerImpl
extends FileServerPOA {
    MemoryMXBean memoryBean;
    private String name;
    private String homeDirectory;
    private String localHost;
    private KnownTransferMethodMap map;

    public FileServerImpl(String homeDirectory) {
        this.homeDirectory = homeDirectory;
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.name = "UNKNOWN";
        try {
            this.localHost = this.name = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        this.name = this.name + " " + System.currentTimeMillis() / 1000L % 1000L;
        this.map = new KnownTransferMethodMap();
        CopyMethodsInitializer.initialize(this.map, this.localHost);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RemoteFile getRoot() {
        Object o = null;
        try {
            o = this._poa().the_parent().find_POA("RemoteFileDefaultServantPOA", false).create_reference_with_id("/".getBytes(), RemoteFileHelper.type().id());
        }
        catch (UserException ex) {
            ex.printStackTrace();
            throw new RuntimeException("A misconfiguration problem occured!");
        }
        return RemoteFileHelper.narrow(o);
    }

    @Override
    public String getCopyServerAddress(String method) {
        return this.map.getAddress(method);
    }

    @Override
    public void shutdown() {
        if ("TRUE".equals(SystemProperties.getProperty("DEBUG_MODE"))) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    System.exit(0);
                }
            }).start();
        }
    }

    @Override
    public long getFreeSpace() throws ServerException {
        try {
            return FileSystemUtils.freeSpace((String)this.homeDirectory);
        }
        catch (Exception e) {
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public void setProperty(String key, String value) throws ServerException {
        SystemProperties.setProperty(key, value);
    }

    @Override
    public String getProperty(String key) throws ServerException {
        return SystemProperties.getProperty(key);
    }

    @Override
    public long getUsedMemory() throws ServerException {
        this.memoryBean.gc();
        return this.memoryBean.getHeapMemoryUsage().getUsed();
    }

    @Override
    public String getMemoryStatus(boolean callGC) throws ServerException {
        if (callGC) {
            this.memoryBean.gc();
        }
        MemoryUsage heap = this.memoryBean.getHeapMemoryUsage();
        MemoryUsage nonHeap = this.memoryBean.getNonHeapMemoryUsage();
        StringBuffer buf = new StringBuffer();
        buf.append("\tHEAP INIT:");
        buf.append(heap.getInit());
        buf.append("\tHEAP COMMITTED:");
        buf.append(heap.getCommitted());
        buf.append("\tHEAP USED:");
        buf.append(heap.getUsed());
        buf.append("\tHEAP MAX:");
        buf.append(heap.getMax());
        buf.append("\tNON-HEAP INIT:");
        buf.append(nonHeap.getInit());
        buf.append("\tNON-HEAP COMMITTED:");
        buf.append(nonHeap.getCommitted());
        buf.append("\tNON-HEAP USED:");
        buf.append(nonHeap.getUsed());
        buf.append("\tNON-HEAP MAX:");
        buf.append(nonHeap.getMax());
        return buf.toString();
    }

    @Override
    public double getAverageTransferRateToHost(String fileServerName) throws ServerException {
        try {
            return DataTransferPerformanceTracker.getInstance().getAverageTransferRateToSpecificHost(fileServerName);
        }
        catch (UnavailableInformationException exc) {
            System.out.println("Returning 0 to average request");
            return 0.0;
        }
        catch (Exception exc) {
            throw ServerExceptionBuilder.createServerException(exc);
        }
    }

    @Override
    public void resetTransferRateData() throws ServerException {
        try {
            DataTransferPerformanceTracker.getInstance().resetTransferRateData();
        }
        catch (Exception exc) {
            throw ServerExceptionBuilder.createServerException(exc);
        }
    }

    public DataTransferMethod getDataTransferMethod(String method) {
        return this.map.getMethod(method);
    }

    @Override
    public String getFileSeparator() {
        return String.valueOf(Util.getLocalFileSeparator());
    }
}

