/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.performancetracker;

import csfs.impl.performancetracker.DataTransferInfo;
import csfs.impl.performancetracker.UnavailableInformationException;
import java.util.HashMap;

public class DataTransferPerformanceTracker {
    private static DataTransferPerformanceTracker instance;
    private HashMap history;

    private DataTransferPerformanceTracker() {
        this.resetTransferRateData();
    }

    public static synchronized DataTransferPerformanceTracker getInstance() {
        if (instance == null) {
            instance = new DataTransferPerformanceTracker();
        }
        return instance;
    }

    public synchronized void update(String destination, long bytes, long time) {
        System.out.println("destination=" + destination + ",bytes=" + bytes + "time=" + time);
        DataTransferInfo info = (DataTransferInfo)this.history.get(destination);
        if (info == null) {
            info = new DataTransferInfo();
            this.history.put(destination, info);
        }
        info.update(bytes, time);
    }

    public synchronized double getAverageTransferRateToSpecificHost(String destination) throws UnavailableInformationException {
        DataTransferInfo info = (DataTransferInfo)this.history.get(destination);
        if (info == null) {
            throw new UnavailableInformationException("No data available for host: " + destination);
        }
        return info.getAverageTransferRate();
    }

    public double getAverageTransferRate() throws UnavailableInformationException {
        if (this.history.size() == 0) {
            throw new UnavailableInformationException("No data available!");
        }
        double totalBytes = 0.0;
        double totalTime = 0.0;
        DataTransferInfo[] infos = this.history.values().toArray(new DataTransferInfo[0]);
        for (int i = 0; i < infos.length; ++i) {
            totalBytes = infos[i].getTotalBytesTransferred();
            totalTime = infos[i].getTotalTime();
        }
        return totalBytes / (totalTime / 1000.0);
    }

    public void resetTransferRateData() {
        System.out.println("Reset called!");
        this.history = new HashMap();
    }
}

