/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.util;

import java.io.File;

public class FileLocker {
    private static final String LOCK_FILE_SUFFIX = ".lock";

    public boolean tryLock(File file) {
        File lock = this.getLockFile(file);
        return lock.mkdir();
    }

    public boolean unlock(File file) {
        File lock = this.getLockFile(file);
        return lock.delete();
    }

    private File getLockFile(File file) {
        if (null == file) {
            throw new IllegalArgumentException("File is null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " does not exists or is not a normal file.");
        }
        return new File(file.getParent(), file.getName() + LOCK_FILE_SUFFIX);
    }

    public boolean isLockFile(String fileName) {
        return fileName.endsWith(LOCK_FILE_SUFFIX);
    }
}

