/*
 * Decompiled with CFR 0.152.
 */
package csfs.remote;

import csfs.remote.FileServer;
import csfs.remote.FileServerHelper;
import csfs.remote.FileServerOperations;
import csfs.remote.RemoteFileHelper;
import csfs.remote.ServerException;
import csfs.remote.ServerExceptionHelper;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class FileServerPOA
extends Servant
implements InvokeHandler,
FileServerOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:csfs/remote/FileServer:1.0"};

    public FileServer _this() {
        return FileServerHelper.narrow(this._this_object());
    }

    public FileServer _this(ORB oRB) {
        return FileServerHelper.narrow(this._this_object(oRB));
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_ulonglong(this.getFreeSpace());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 1: {
                try {
                    String string2 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    outputStream.write_double(this.getAverageTransferRateToHost(string2));
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 2: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_longlong(this.getUsedMemory());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 3: {
                try {
                    outputStream = responseHandler.createReply();
                    this.shutdown();
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 4: {
                try {
                    outputStream = responseHandler.createReply();
                    RemoteFileHelper.write(outputStream, this.getRoot());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 5: {
                try {
                    String string3 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    outputStream.write_string(this.getProperty(string3));
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 6: {
                try {
                    outputStream = responseHandler.createReply();
                    this.resetTransferRateData();
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 7: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_string(this.getFileSeparator());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 8: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_string(this.getName());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 9: {
                try {
                    boolean bl = inputStream.read_boolean();
                    outputStream = responseHandler.createReply();
                    outputStream.write_string(this.getMemoryStatus(bl));
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 10: {
                try {
                    String string4 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    outputStream.write_string(this.getCopyServerAddress(string4));
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 11: {
                try {
                    String string5 = inputStream.read_string();
                    String string6 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    this.setProperty(string5, string6);
                    break;
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    static {
        m_opsHash.put("getFreeSpace", new Integer(0));
        m_opsHash.put("getAverageTransferRateToHost", new Integer(1));
        m_opsHash.put("getUsedMemory", new Integer(2));
        m_opsHash.put("shutdown", new Integer(3));
        m_opsHash.put("getRoot", new Integer(4));
        m_opsHash.put("getProperty", new Integer(5));
        m_opsHash.put("resetTransferRateData", new Integer(6));
        m_opsHash.put("getFileSeparator", new Integer(7));
        m_opsHash.put("getName", new Integer(8));
        m_opsHash.put("getMemoryStatus", new Integer(9));
        m_opsHash.put("getCopyServerAddress", new Integer(10));
        m_opsHash.put("setProperty", new Integer(11));
    }
}

