/*
 * Decompiled with CFR 0.152.
 */
package jni.precisionclock;

public class PrecisionChronometer {
    private long nativeStartTime;
    private long systemStartTime;

    public void reset() {
        this.nativeStartTime = this.getTime();
        this.systemStartTime = System.currentTimeMillis();
    }

    public long elapsedTime() {
        long nativeTime = this.getTime();
        long systemTime = System.currentTimeMillis();
        long systemElapsedTime = systemTime - this.systemStartTime;
        long response = systemElapsedTime < 1000000L ? nativeTime - this.nativeStartTime : systemElapsedTime * 1000L;
        return response;
    }

    private native long getTime();

    static {
        System.loadLibrary("PrecisionClock");
    }
}

