local _G = require "_G"
local ipairs = _G.ipairs

local array = require "table"
local unpack = array.unpack or _G.unpack

local debug = require "debug"
local traceback = debug.traceback

local makeaux = require "sga.idlaux"
local parsed = require "sga.parsed"

local types, const, throw = {}, {}, {}
for _, parsed in ipairs(parsed) do
  makeaux(parsed, types, const, throw)
end

local idl = {
  types = types.sgaidl,
  const = const.sgaidl,
  throw = throw.sgaidl,
}

function idl.loadto(orb)
  orb.TypeRepository.registry:register(unpack(parsed))
end

return idl
