/*
 * Decompiled with CFR 0.152.
 */
package csfs.client;

import csfs.remote.FileServer;
import csfs.remote.FileServerHelper;
import csfs.remote.InvalidStateException;
import csfs.remote.NotDirectoryException;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import csfs.remote.WriteChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class TestScalability {
    private static int counter = 0;
    private long absoluteStartTime = 0L;
    private static int coolingTime = 120000;
    private static int preVerifyCoolingTime = 180000;
    private boolean finished = false;
    private long MB = 0x100000L;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public synchronized void go(String[] args) {
        try {
            ORB orb = ORB.init((String[])args, null);
            String targetHost = "n7";
            int targetPort = 10000;
            String[] sourceHosts = new String[]{"n1", "n2", "n4", "n5", "n6"};
            int[] sourcePorts = new int[]{10000, 10000, 10000, 10000, 10000};
            String targetCorbaloc = "corbaloc::1.2@" + targetHost + ":" + targetPort + "/standardImplName/FileServerPOA/FileServer";
            Object targetObj = orb.string_to_object(targetCorbaloc);
            FileServer targetServer = FileServerHelper.narrow(targetObj);
            FileServer[] sourceServers = new FileServer[sourceHosts.length];
            for (int i = 0; i < sourceServers.length; ++i) {
                FileServer sourceServer;
                String sourceCorbaloc = "corbaloc::1.2@" + sourceHosts[i] + ":" + sourcePorts[i] + "/standardImplName/FileServerPOA/FileServer";
                Object sourceObj = orb.string_to_object(sourceCorbaloc);
                sourceServers[i] = sourceServer = FileServerHelper.narrow(sourceObj);
            }
            this.runCopyScalabilityTest(sourceHosts, targetServer, sourceServers);
            this.finished = true;
            System.out.println("FINALIZADO!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void runFileScalabilityTest(FileServer targetServer) throws ServerException {
        RemoteFile[] children = null;
        try {
            children = targetServer.getRoot().getChildren();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (children == null || children.length > 0) {
            System.out.println("ERROR: targetServer.getRoot() - Is it empty?");
            System.exit(1);
        }
        try {
            this.testSingleFileSetScalability(targetServer, 10, 2, true, 0);
            this.testSingleFileSetScalability(targetServer, 10, 2, true, 65536);
            this.testSingleFileSetScalability(targetServer, 10, 2, true, 131072);
            this.testSingleFileSetScalability(targetServer, 10, 3, false, 0);
            this.testSingleFileSetScalability(targetServer, 10, 4, false, 0);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void testSingleFileSetScalability(FileServer targetServer, int branch, int depth, boolean openChannel, int fileBuffer) throws ServerException, InterruptedException, Exception, InvalidStateException, NotDirectoryException {
        RemoteFile root = targetServer.getRoot();
        System.out.println("\n\n\nBranch=" + branch);
        System.out.println("Depth=" + depth);
        System.out.println("FileBuffer=" + fileBuffer);
        System.out.println("\nInitial State!");
        this.printMemoryStatus(targetServer, 2000);
        ArrayList files = new ArrayList();
        this.createDirectories(root, branch, depth, files);
        this.createFileAtLeaves(root, branch, files);
        System.out.println("\nCreating done!");
        long elementsCreated = files.size();
        System.out.println("elementsCreated=" + elementsCreated);
        this.printMemoryStatus(targetServer, 2000);
        if (openChannel) {
            this.testOpenChannelScalability(files, targetServer, fileBuffer);
        }
        for (int i = files.size() - 1; i >= 0; --i) {
            ((RemoteFile)files.get(i)).remove();
        }
        System.out.println("Final State");
        this.printMemoryStatus(targetServer, 2000);
    }

    private void createDirectories(RemoteFile file, int num, int depth, List files) throws Exception {
        if (depth > 0) {
            for (int i = 0; i < num; ++i) {
                RemoteFile child = file.createDirectory(new String[]{"dir_" + i});
                files.add(child);
                this.createDirectories(child, num, depth - 1, files);
            }
        }
    }

    private void createFileAtLeaves(RemoteFile dir, int num, List files) throws Exception {
        RemoteFile[] children = dir.getChildren();
        if (children.length == 0) {
            for (int i = 0; i < num; ++i) {
                RemoteFile file = dir.createFile(new String[]{"file_" + i});
                files.add(file);
            }
        } else {
            for (int i = 0; i < children.length; ++i) {
                this.createFileAtLeaves(children[i], num, files);
            }
        }
    }

    private void testOpenChannelScalability(List files, FileServer targetServer, int fileBuffer) throws Exception {
        RemoteFile file;
        ArrayList<WriteChannel> channels = new ArrayList<WriteChannel>();
        targetServer.setProperty("BUFFERED_STREAMS_SIZE", "" + fileBuffer);
        for (int index = files.size(); index > 0 && !(file = (RemoteFile)files.get(index - 1)).isDirectory(); --index) {
            channels.add(file.getWriteChannel());
        }
        System.out.println("channels.size()=" + channels.size());
        this.printMemoryStatus(targetServer, 2000);
        for (int i = 0; i < channels.size(); ++i) {
            ((WriteChannel)channels.get(i)).close();
        }
        System.out.println("Channels Closed!");
        this.printMemoryStatus(targetServer, 1000 + (int)Math.log(channels.size() * 100));
    }

    private void printMemoryStatus(FileServer targetServer, int queryDelay) throws ServerException, InterruptedException {
        for (int i = 0; i < 5; ++i) {
            System.out.println("" + new Date().getTime() + "\tMEMORY STATUS:" + targetServer.getMemoryStatus(true));
            Thread.sleep(queryDelay);
        }
    }

    private void runCopyScalabilityTest(String[] sourceHosts, FileServer targetServer, FileServer[] sourceServers) throws ServerException {
        int i;
        this.startMemoryGrabberThread(targetServer);
        String[] methods = new String[]{"CORBA-32768"};
        int numRuns = 2;
        String[] basefile = new String[]{"1GB"};
        long[] filesize = new long[]{1024L * this.MB};
        int[] singleCopyParallelismArray = new int[basefile.length];
        Arrays.fill(singleCopyParallelismArray, 1);
        System.out.println("\n\n\nSINGLE CLIENT! SINGLE THREAD!!!\n\n");
        for (i = 0; i < methods.length; ++i) {
            this.runCopyTest(methods[i], numRuns, singleCopyParallelismArray, basefile, filesize, new String[]{sourceHosts[0]}, targetServer, new FileServer[]{sourceServers[0]});
        }
        System.out.println("\n\n\nMULTI CLIENT! SINGLE THREAD!!!\n\n");
        for (i = 0; i < methods.length; ++i) {
            this.runCopyTest(methods[i], numRuns, singleCopyParallelismArray, basefile, filesize, sourceHosts, targetServer, sourceServers);
        }
        System.out.println("\n\n\nMULTI CLIENT! MULTI THREAD!!!\n\n");
        int[] parallelism = new int[]{8, 8};
        basefile = new String[]{"128MB", "64MB"};
        filesize = new long[]{128L * this.MB, 64L * this.MB};
        for (i = 0; i < methods.length; ++i) {
            this.runCopyTest(methods[i], numRuns, parallelism, basefile, filesize, sourceHosts, targetServer, sourceServers);
        }
    }

    private synchronized void runCopyTest(String method, int numRuns, int[] parallelism, String[] basefile, long[] filesize, String[] sourceHosts, FileServer targetServer, FileServer[] sourceServers) throws ServerException {
        int i;
        if (parallelism.length != basefile.length || parallelism.length != filesize.length) {
            System.out.println("ERROR: check parallelism, basefile and filesize arrays!!!");
            System.exit(1);
        }
        RemoteFile[] children = null;
        try {
            children = targetServer.getRoot().getChildren();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (children == null || children.length > 0) {
            System.out.println("ERROR: targetServer.getRoot() is not empty!");
            System.exit(1);
        }
        for (i = 0; i < sourceServers.length; ++i) {
            sourceServers[i].resetTransferRateData();
        }
        System.out.println("\n\n\n\nmethod=" + method);
        System.out.println("TIME:" + System.currentTimeMillis());
        System.out.println("numRuns=" + numRuns);
        for (i = 0; i < parallelism.length; ++i) {
            System.out.println("parallelism[" + i + "]=" + parallelism[i] + "\tbasefile[" + i + "]=" + basefile[i] + "\tfilesize[" + i + "]=" + filesize[i]);
        }
        boolean tryLongRun = true;
        for (int i2 = 0; i2 < numRuns; ++i2) {
            for (int j = 0; j < parallelism.length; ++j) {
                Exception failure = null;
                String failureMessage = null;
                try {
                    int k;
                    ReliableCopyThread[] threads = null;
                    long start = 0L;
                    int threadIndex = 0;
                    if (sourceHosts.length * parallelism[j] == 1 && tryLongRun) {
                        threads = new ReliableCopyThread[8];
                        threadIndex = 0;
                        start = System.currentTimeMillis();
                        System.out.println("\n\nDATA:\t" + this.dateFormatter.format(new Date(start)) + "\tIniciando!\thosts:\t" + sourceHosts.length + "\tthreads:\t" + parallelism[j] + "\tsequential:\t" + 8 + "\tmetodo:\t" + method + "\tFILE:\t" + basefile[j] + "\tTIME:\t" + start + "\n");
                        this.absoluteStartTime = start;
                        for (int g = 0; g < threads.length; ++g) {
                            String filename = basefile[j] + "_" + (g + 1);
                            RemoteFile sourceFile = sourceServers[0].getRoot().getChild(new String[]{filename});
                            RemoteFile targetFile = targetServer.getRoot().createFile(new String[]{filename + "." + method + "." + sourceHosts[0] + "." + threadIndex});
                            threads[threadIndex] = new ReliableCopyThread(method, this, sourceFile, targetFile, 0, method);
                            counter = threadIndex;
                            if (threadIndex < threads.length - 1) {
                                threads[threadIndex].start();
                                ++threadIndex;
                                while (counter < threadIndex) {
                                    this.wait();
                                }
                                continue;
                            }
                            threads[threads.length - 1].start();
                        }
                    } else {
                        int l;
                        threads = new ReliableCopyThread[sourceHosts.length * parallelism[j]];
                        threadIndex = 0;
                        for (l = 0; l < parallelism[j]; ++l) {
                            for (int k2 = 0; k2 < sourceHosts.length; ++k2) {
                                String filename = basefile[j] + "_" + (l + 1);
                                int delay = (int)Math.min((long)(threadIndex * threadIndex / (int)Math.pow(2.0, Math.max(sourceHosts.length - 1, 0))) * (filesize[j] / 2465792L), filesize[j] / 1232896L * (long)sourceHosts.length * (long)parallelism[j] * 4L);
                                RemoteFile sourceFile = sourceServers[k2].getRoot().getChild(new String[]{filename});
                                RemoteFile targetFile = targetServer.getRoot().createFile(new String[]{filename + "." + method + "." + sourceHosts[k2] + "." + threadIndex});
                                threads[threadIndex] = new ReliableCopyThread(method, this, sourceFile, targetFile, delay, method);
                                ++threadIndex;
                            }
                        }
                        counter = 0;
                        start = System.currentTimeMillis();
                        System.out.println("\n\nDATA:\t" + this.dateFormatter.format(new Date(start)) + "\tIniciando!\thosts:\t" + sourceHosts.length + "\tthreads:\t" + parallelism[j] + "\tsequential:\t" + 1 + "\tmetodo:\t" + method + "\tFILE:\t" + basefile[j] + "\tTIME:\t" + start + "\n");
                        this.absoluteStartTime = start;
                        for (l = 0; l < threads.length; ++l) {
                            threads[l].start();
                        }
                    }
                    while (counter < threads.length) {
                        this.wait();
                    }
                    long end = System.currentTimeMillis();
                    Thread.sleep(5000L);
                    targetServer.getMemoryStatus(true);
                    System.out.println("Cooling down!!!");
                    Thread.sleep(preVerifyCoolingTime);
                    System.out.println("Verifying copies!!!");
                    children = targetServer.getRoot().getChildren();
                    long totalBytes = 0L;
                    for (int k3 = 0; k3 < children.length; ++k3) {
                        totalBytes += children[k3].size();
                    }
                    long expectedTotalBytes = sourceHosts.length * parallelism[j] == 1 && tryLongRun ? 8L * filesize[j] : (long)parallelism[j] * filesize[j] * (long)sourceHosts.length;
                    if (totalBytes != expectedTotalBytes) {
                        failureMessage = "Method:" + method + " failed! totalBytes=" + totalBytes + " expectedTotalBytes=" + expectedTotalBytes + " parallelism[j]=" + parallelism[j] + " filesize[j]=" + filesize[j] + " sourceHosts.length=" + sourceHosts.length;
                    } else {
                        GetHashThread sourceHash = null;
                        GetHashThread targetHash = null;
                        for (k = 0; k < threads.length && failureMessage == null; ++k) {
                            sourceHash = new GetHashThread(this, threads[k].getSourceFile());
                            targetHash = new GetHashThread(this, threads[k].getTargetFile());
                            counter = 0;
                            sourceHash.start();
                            targetHash.start();
                            while (counter < 2) {
                                this.wait();
                            }
                            if (sourceHash.getException() != null) {
                                failureMessage = "Method:" + method + " failed! parallelism[j]=" + parallelism[j] + " filesize[j]=" + filesize[j] + " sourceHosts.length=" + sourceHosts.length;
                                failure = sourceHash.getException();
                            }
                            if (targetHash.getException() != null) {
                                failureMessage = "Method:" + method + " failed! parallelism[j]=" + parallelism[j] + " filesize[j]=" + filesize[j] + " sourceHosts.length=" + sourceHosts.length;
                                failure = targetHash.getException();
                            }
                            if (failureMessage != null) continue;
                            if (!Arrays.equals(sourceHash.getHashResult(), targetHash.getHashResult())) {
                                failureMessage = "Method:" + method + " failed! Hashes differ!!! parallelism[j]=" + parallelism[j] + " filesize[j]=" + filesize[j] + " sourceHosts.length=" + sourceHosts.length + " sourceHash.getFile().getName()=" + sourceHash.getFile().getName() + " targetHash.getFile().getName()=" + targetHash.getFile().getName();
                                continue;
                            }
                            System.out.println("HASH OK!!! k=" + k);
                        }
                    }
                    System.out.println("\nDATA:\t" + this.dateFormatter.format(new Date(end)) + "\tFinalizado!\thosts:\t" + sourceHosts.length + "\tthreads:\t" + parallelism[j] + "\tmetodo:\t" + method + "\tFILE:\t" + basefile[j] + "\tTIME:\t" + end + "\n");
                    System.out.println("**********");
                    System.out.println("***** metodo:\t" + method);
                    System.out.println("***** data (MBytes):\t" + (double)expectedTotalBytes / 1048576.0);
                    System.out.println("***** tempo (ms):\t" + (end - start));
                    if (failureMessage == null && failure == null) {
                        System.out.println("***** taxa (MB/s):\t" + (double)expectedTotalBytes / 1048576.0 / ((double)(end - start) / 1000.0));
                        System.out.println("***** status: SUCCESS");
                        System.out.println("*****");
                        System.out.println("***** file:\t" + basefile[j]);
                        double sum = 0.0;
                        for (k = 0; k < sourceServers.length; ++k) {
                            double rate = sourceServers[k].getAverageTransferRateToHost(targetServer.getName());
                            sum += rate;
                            System.out.println("+++++ AverageRate: from" + sourceServers[k].getName() + " to " + targetServer.getName() + " = " + rate);
                        }
                        System.out.println("+++++ AggregatedRate: to " + targetServer.getName() + " = " + sum);
                    }
                    children = targetServer.getRoot().getChildren();
                    for (int k4 = 0; k4 < children.length; ++k4) {
                        children[k4].remove();
                    }
                }
                catch (Exception e) {
                    failure = e;
                }
                if (failureMessage != null) {
                    System.out.println("***** status: FAILURE");
                    System.out.println("\nDATA:\t" + this.dateFormatter.format(new Date()) + " failureMessage=" + failureMessage);
                    System.out.println("*****");
                    System.out.println("***** file:\t" + basefile[j]);
                }
                if (failure != null) {
                    System.out.println("***** status: FAILURE");
                    System.err.println("\nDATA:\t" + this.dateFormatter.format(new Date()) + " failure.getMessage()=" + failure.getMessage());
                    System.out.println("*****");
                    System.out.println("***** file:\t" + basefile[j]);
                    failure.printStackTrace();
                }
                System.out.println("******** END TIME:\t" + System.currentTimeMillis());
                System.out.println("**********");
                try {
                    Thread.sleep(coolingTime);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("\n\n\n\nmethod(FINISHED)=" + method);
        System.out.println("TIME:" + System.currentTimeMillis());
    }

    public synchronized void notifyEnd() {
        ++counter;
        this.notify();
    }

    public static void main(String[] args) {
        TestScalability test = new TestScalability();
        test.go(args);
    }

    private void startMemoryGrabberThread(final FileServer targetServer) {
        new Thread(){

            @Override
            public void run() {
                while (!TestScalability.this.finished) {
                    try {
                        System.out.println("DATE:" + TestScalability.this.dateFormatter.format(new Date()) + targetServer.getMemoryStatus(false));
                        1.sleep(10000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    class GetHashThread
    extends Thread {
        private TestScalability parent;
        private RemoteFile file;
        private Exception exception;
        private byte[] hashResult;

        public GetHashThread(TestScalability parent, RemoteFile file) {
            this.parent = parent;
            this.file = file;
        }

        @Override
        public void run() {
            try {
                this.hashResult = this.file.hash();
                this.parent.notifyEnd();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public RemoteFile getFile() {
            return this.file;
        }

        public Exception getException() {
            return this.exception;
        }

        public byte[] getHashResult() {
            return this.hashResult;
        }
    }

    class ReliableCopyThread
    extends Thread {
        private TestScalability parent;
        private String id;
        private RemoteFile sourceFile;
        private RemoteFile targetFile;
        private Exception exception;
        private int initialDelay;
        private String method;

        public ReliableCopyThread(String id, TestScalability parent, RemoteFile sourceFile, RemoteFile targetFile, int initialDelay, String method) {
            this.id = id;
            this.parent = parent;
            this.sourceFile = sourceFile;
            this.targetFile = targetFile;
            this.initialDelay = initialDelay;
            this.method = method;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.initialDelay);
                long start = System.currentTimeMillis();
                System.out.println("DATA:\t" + TestScalability.this.dateFormatter.format(new Date(start)) + "\tNAME:" + this.getName() + "\tid=" + this.id + "\tinitialDelay=" + this.initialDelay);
                this.sourceFile.copyTo(this.targetFile, this.method);
                long end = System.currentTimeMillis();
                System.out.println("DATA:\t" + TestScalability.this.dateFormatter.format(new Date(end)) + "\tNAME:" + this.getName() + "\tid=" + this.id + " ABSOLUTE:" + (end - TestScalability.this.absoluteStartTime) + " LOCAL:" + (end - start));
                this.parent.notifyEnd();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.exception = e;
            }
        }

        public RemoteFile getSourceFile() {
            return this.sourceFile;
        }

        public RemoteFile getTargetFile() {
            return this.targetFile;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

