/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.alternatives;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.VerifyingVisitor;

public class ImmutablePicoContainer
implements PicoContainer,
Serializable {
    private PicoContainer delegate;

    public ImmutablePicoContainer(PicoContainer picoContainer) {
        if (picoContainer == null) {
            throw new NullPointerException("You must pass in a picoContainer instance");
        }
        this.delegate = picoContainer;
    }

    public Object getComponentInstance(Object object) {
        return this.delegate.getComponentInstance(object);
    }

    public Object getComponentInstanceOfType(Class clazz) {
        return this.delegate.getComponentInstanceOfType(clazz);
    }

    public List getComponentInstances() {
        return this.delegate.getComponentInstances();
    }

    public synchronized PicoContainer getParent() {
        return this.delegate.getParent();
    }

    public ComponentAdapter getComponentAdapter(Object object) {
        return this.delegate.getComponentAdapter(object);
    }

    public ComponentAdapter getComponentAdapterOfType(Class clazz) {
        return this.delegate.getComponentAdapterOfType(clazz);
    }

    public Collection getComponentAdapters() {
        return this.delegate.getComponentAdapters();
    }

    public List getComponentAdaptersOfType(Class clazz) {
        return this.delegate.getComponentAdaptersOfType(clazz);
    }

    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse(this);
    }

    public List getComponentInstancesOfType(Class clazz) throws PicoException {
        return this.delegate.getComponentInstancesOfType(clazz);
    }

    public void accept(PicoVisitor picoVisitor) {
        this.delegate.accept(picoVisitor);
    }

    public void start() {
        throw new UnsupportedOperationException("This container is immutable, start() is not allowed");
    }

    public void stop() {
        throw new UnsupportedOperationException("This container is immutable, stop() is not allowed");
    }

    public void dispose() {
        throw new UnsupportedOperationException("This container is immutable, dispose() is not allowed");
    }
}

