/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.listener.SSLSessionEvent;
import org.jacorb.orb.listener.SSLSessionListener;
import org.slf4j.Logger;

public class SSLHandshakeListener
implements HandshakeCompletedListener {
    private final Logger logger;
    private final SSLSessionListener sslListener;

    public SSLHandshakeListener(Logger logger, SSLSessionListener listener) {
        this.logger = logger;
        this.sslListener = listener;
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        Certificate[] certs = null;
        String localhost = null;
        try {
            certs = event.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handshakeCompleted - SSLPeerUnverifiedException", (Throwable)ex);
            }
            certs = new Certificate[]{};
        }
        localhost = IIOPAddress.getLocalHostAddress(this.logger);
        this.sslListener.sessionCreated(new SSLSessionEvent(event.getSource(), event.getSocket().getInetAddress().getHostAddress(), event.getSocket().getPort(), certs, event.getSocket().getLocalPort(), localhost, null));
    }
}

