/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeSpec;

public class CharType
extends BaseType
implements SwitchTypeSpec {
    private boolean wide = false;

    public CharType(int num) {
        super(num);
    }

    @Override
    public Object clone() {
        CharType s = new CharType(CharType.new_num());
        if (this.wide) {
            s.setWide();
        }
        return s;
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide() {
        this.wide = true;
    }

    @Override
    public String typeName() {
        return "char";
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        if (this.wide) {
            return 26;
        }
        return 9;
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.CharHolder";
    }

    @Override
    public String printReadExpression(String strname) {
        if (this.wide) {
            return strname + ".read_wchar()";
        }
        return strname + ".read_char()";
    }

    @Override
    public String printWriteStatement(String var_name, String strname) {
        if (this.wide) {
            return strname + ".write_wchar(" + var_name + ");";
        }
        return strname + ".write_char(" + var_name + ");";
    }

    @Override
    public String printInsertExpression() {
        if (this.wide) {
            return "insert_wchar";
        }
        return "insert_char";
    }

    @Override
    public String printExtractExpression() {
        if (this.wide) {
            return "extract_wchar";
        }
        return "extract_char";
    }

    @Override
    public boolean isSwitchable() {
        return !this.wide;
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + "." + this.printInsertExpression() + "(" + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + anyname + "." + this.printExtractExpression() + "();");
    }
}

