/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

public class LongLongType
extends IntType {
    public LongLongType(int num) {
        super(num);
    }

    @Override
    public Object clone() {
        return new LongLongType(LongLongType.new_num());
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public String typeName() {
        return "long";
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public int getTCKind() {
        if (this.unsigned) {
            return 24;
        }
        return 23;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public String holderName() {
        return "org.omg.CORBA.LongHolder";
    }

    @Override
    public String printReadExpression(String strname) {
        if (this.unsigned) {
            return strname + ".read_ulonglong()";
        }
        return strname + ".read_longlong()";
    }

    @Override
    public String printReadStatement(String var_name, String strname) {
        if (this.unsigned) {
            return var_name + "=" + strname + ".read_ulonglong();";
        }
        return var_name + "=" + strname + ".read_longlong();";
    }

    @Override
    public String printWriteStatement(String var_name, String strname) {
        if (this.unsigned) {
            return strname + ".write_ulonglong(" + var_name + ");";
        }
        return strname + ".write_longlong(" + var_name + ");";
    }

    @Override
    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ulonglong";
        }
        return "insert_longlong";
    }

    @Override
    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ulonglong";
        }
        return "extract_longlong";
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + "." + this.printInsertExpression() + "(" + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + anyname + "." + this.printExtractExpression() + "();");
    }
}

