/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.remoting.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.nanocontainer.remoting.jmx.DynamicMBeanFactory;
import org.nanocontainer.remoting.jmx.DynamicMBeanProvider;
import org.nanocontainer.remoting.jmx.JMXRegistrationException;
import org.nanocontainer.remoting.jmx.JMXRegistrationInfo;
import org.nanocontainer.remoting.jmx.StandardMBeanFactory;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

public class RegisteredMBeanConstructingProvider
implements DynamicMBeanProvider {
    private final DynamicMBeanFactory factory;
    private final Map registry;

    public RegisteredMBeanConstructingProvider() {
        this(new StandardMBeanFactory());
    }

    public RegisteredMBeanConstructingProvider(DynamicMBeanFactory dynamicMBeanFactory) {
        this.factory = dynamicMBeanFactory;
        this.registry = new HashMap();
    }

    public JMXRegistrationInfo provide(PicoContainer picoContainer, ComponentAdapter componentAdapter) {
        Object object = componentAdapter.getComponentKey();
        MBeanInfoWrapper mBeanInfoWrapper = (MBeanInfoWrapper)this.registry.get(object);
        if (mBeanInfoWrapper != null) {
            Object object2 = componentAdapter.getComponentInstance(picoContainer);
            Class<?> clazz = mBeanInfoWrapper.getManagementInterface() != null ? mBeanInfoWrapper.getManagementInterface() : (object instanceof Class ? (Class)object : object2.getClass());
            DynamicMBean dynamicMBean = this.factory.create(object2, clazz, mBeanInfoWrapper.getMBeanInfo());
            return new JMXRegistrationInfo(mBeanInfoWrapper.getObjectName(), dynamicMBean);
        }
        return null;
    }

    public void register(Object object, ObjectName objectName, Class clazz, MBeanInfo mBeanInfo) {
        this.registry.put(object, new MBeanInfoWrapper(mBeanInfo, objectName, clazz));
    }

    public void register(Object object, ObjectName objectName, MBeanInfo mBeanInfo) {
        this.register(object, objectName, null, mBeanInfo);
    }

    public void register(ObjectName objectName, MBeanInfo mBeanInfo) {
        try {
            this.register(this.getClass().getClassLoader().loadClass(mBeanInfo.getClassName()), objectName, mBeanInfo);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JMXRegistrationException("Cannot access class " + mBeanInfo.getClassName() + " of MBean", classNotFoundException);
        }
    }

    public void register(Object object, ObjectName objectName) {
        this.registry.put(object, new MBeanInfoWrapper(null, objectName, null));
    }

    private static class MBeanInfoWrapper {
        private final MBeanInfo mBeanInfo;
        private final ObjectName objectName;
        private final Class managementInterface;

        MBeanInfoWrapper(MBeanInfo mBeanInfo, ObjectName objectName, Class clazz) {
            this.mBeanInfo = mBeanInfo;
            this.objectName = objectName;
            this.managementInterface = clazz;
        }

        MBeanInfo getMBeanInfo() {
            return this.mBeanInfo;
        }

        ObjectName getObjectName() {
            return this.objectName;
        }

        Class getManagementInterface() {
            return this.managementInterface;
        }
    }
}

