/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DelegatingComponentMonitor;
import org.picocontainer.defaults.MonitoringComponentAdapter;

public abstract class AbstractComponentAdapter
extends MonitoringComponentAdapter {
    private Object componentKey;
    private Class componentImplementation;

    protected AbstractComponentAdapter(Object object, Class clazz) throws AssignabilityRegistrationException {
        this(object, clazz, new DelegatingComponentMonitor());
    }

    protected AbstractComponentAdapter(Object object, Class clazz, ComponentMonitor componentMonitor) throws AssignabilityRegistrationException {
        super(componentMonitor);
        if (clazz == null) {
            throw new NullPointerException("componentImplementation");
        }
        this.componentKey = object;
        this.componentImplementation = clazz;
        this.checkTypeCompatibility();
    }

    public Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    public Class getComponentImplementation() {
        return this.componentImplementation;
    }

    protected void checkTypeCompatibility() throws AssignabilityRegistrationException {
        Class clazz;
        if (this.componentKey instanceof Class && !(clazz = (Class)this.componentKey).isAssignableFrom(this.componentImplementation)) {
            throw new AssignabilityRegistrationException(clazz, this.componentImplementation);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getComponentKey() + "]";
    }

    public void accept(PicoVisitor picoVisitor) {
        picoVisitor.visitComponentAdapter(this);
    }
}

