/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.nonblockingnio;

import csfs.datatransfer.nonblockingnio.ImportHandler;
import csfs.datatransfer.nonblockingnio.ImportState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

public class GettingFile
extends ImportState {
    public GettingFile(ImportHandler handler) {
        this.remainingBytes = handler.getFileSize();
        this.handler = handler;
    }

    @Override
    public void read() throws IOException {
        long size = this.handler.getFileSize();
        SocketChannel sourceChannel = this.handler.getSourceChannel();
        FileChannel targetChannel = this.handler.getTargetChannel();
        long bytesRead = targetChannel.transferFrom(sourceChannel, size - this.remainingBytes, this.remainingBytes);
        this.decRemainingBytes(bytesRead);
    }

    @Override
    protected void decRemainingBytes(long value) throws IOException {
        this.remainingBytes -= value;
        if (this.remainingBytes == 0L) {
            this.sendAck();
            this.handler.close();
        }
    }

    private void sendAck() throws IOException {
        ByteBuffer ack = ByteBuffer.allocateDirect(1);
        ack.put((byte)10);
        ack.flip();
        SocketChannel sourceChannel = this.handler.getSourceChannel();
        sourceChannel.write(ack);
    }
}

