/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.channel;

import csfs.impl.filetracker.FileTracker;
import csfs.impl.filetracker.FileTrackerLeasing;
import csfs.remote.ClosedChannelException;
import csfs.remote.InvalidStateException;
import csfs.remote.OctetSequenceHolder;
import csfs.remote.ReadChannelPOA;
import csfs.remote.RemoteFile;
import csfs.remote.RemoteFileHelper;
import csfs.remote.ServerException;
import java.io.IOException;
import java.io.InputStream;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;

public class ReadChannelDefaultServantImpl
extends ReadChannelPOA {
    @Override
    public int read(int size, OctetSequenceHolder buffer) throws ClosedChannelException, InvalidStateException, ServerException {
        int responseLength = 0;
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            try {
                responseLength = Math.min(size, inputStream.available());
                byte[] response = new byte[responseLength];
                int read = 0;
                int bytesRead = 0;
                while (read < responseLength && bytesRead != -1) {
                    bytesRead = inputStream.read(response, read, responseLength - read);
                    if (bytesRead == -1) continue;
                    read += bytesRead;
                }
                if (read != responseLength) {
                    throw new InvalidStateException("Could NOT read expected " + responseLength + " bytes", this.getFile().getFullName());
                }
                buffer.value = response;
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new InvalidStateException("Unable to perform read operation: " + exc.getMessage(), this.getFile().getFullName());
            }
        } else {
            throw new ClosedChannelException(this._this());
        }
        return responseLength;
    }

    @Override
    public long skip(long num) throws ClosedChannelException, InvalidStateException, ServerException {
        long response = 0L;
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            try {
                num = Math.max(0L, num);
                response = inputStream.skip(num);
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new InvalidStateException("Unable to perform skip operation: " + exc.getMessage(), this.getFile().getFullName());
            }
        } else {
            throw new ClosedChannelException(this._this());
        }
        return response;
    }

    @Override
    public void close() throws InvalidStateException {
        FileTracker tracker = FileTrackerLeasing.getInstance();
        tracker.removeFileDescriptor(this.getObjectId());
    }

    @Override
    public RemoteFile getFile() throws InvalidStateException, ServerException {
        String channelID = this.getObjectId();
        String fileID = channelID.substring(0, channelID.lastIndexOf(95));
        return this.createRemoteFile(fileID);
    }

    @Override
    public boolean isOpen() throws InvalidStateException {
        return this.getInputStream() != null;
    }

    private InputStream getInputStream() throws InvalidStateException {
        return (InputStream)FileTrackerLeasing.getInstance().getFileDescriptor(this.getObjectId());
    }

    private String getObjectId() throws InvalidStateException {
        return new String(this._object_id());
    }

    private RemoteFile createRemoteFile(String path) throws InvalidStateException, ServerException {
        Object o = null;
        try {
            o = this._poa().the_parent().create_reference_with_id(path.getBytes(), RemoteFileHelper.type().id());
        }
        catch (UserException ex) {
            ex.printStackTrace();
            throw new InvalidStateException("Internal misconfiguration problem: " + ex.getMessage(), this.getFile().getFullName());
        }
        return RemoteFileHelper.narrow(o);
    }
}

