/* Bibliotecas necessrias para a compilao */
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <string.h>
#include "math.h"

/* Constante que define o intervalo de tempo em que o benchmark deve ser 
executado */
#define RENEW_BENCH 30
/* Constante para a comparao das datas de criao dos arquivos */
#define BASE_YEAR 2005
/* Constante para a definio do tamanho do buffer do pipe */
#define BUFSIZE 1024

BOOL reRunBench(HANDLE hFile);
BOOL CreateChildProcess(INT processorMask); 
LONG ReadFromPipe(INT); 
VOID ErrorExit(LPTSTR);

HANDLE hChildStdoutRd, hChildStdoutWr, hInputFile, hStdout; 

int main(int argc, char** argv) {
	/* Handle do arquivo de sada do benchmark */
	HANDLE hFile;
	/* Varivel que determina se o benchmark deve ou no ser executado */
	BOOL execBench = FALSE;
	/* Estrutura dos atributos de segurana do pipe a ser criado */
	SECURITY_ATTRIBUTES saAttr; 
	/* Varivel que sinaliza se processo foi criado com sucesso */
    BOOL fSuccess; 
	/* Estrutura com informaes do hardware */
	SYSTEM_INFO siSysInfo;
	/* Nmero de processadores da mquina */
	int numProcs; 
	/* Tempo total de CPU, em milisegundos, dos processos filhos */
	LONG processTime;
	/* Resultado do benchmark em csFlops */
	int result;
	/* Varivel que indica o nmero de bytes escritos em um arquivo */
	DWORD dwWritten;
	/* Buffer de escrita em arquivo */
    char chBuf[BUFSIZE];

	/* Garante que o nome do arquivo de sada foi passado como parmetro */
	if(argc == 1) {
		printf("Usage: test <hostname>");
		exit(0);
	}

	/* Tenta abrir um arquivo de sada j existente */
	hFile = CreateFile(TEXT(argv[1]),     // file to create
                  GENERIC_WRITE,          // open for writing
                  0,                      // do not share
                  NULL,                   // default security
                  OPEN_EXISTING,          // overwrite existing
                  FILE_ATTRIBUTE_NORMAL,  // normal file
                  NULL);                  // no attr. template

	/* Caso no exista um arquivo,  preciso executar o benchmark */
	if(hFile == INVALID_HANDLE_VALUE)
		execBench = TRUE;

	/* Verifica se  necessrio executar o benchmark novamente de acordo com 
	a idade do arquivo existente */
	if(execBench == FALSE)
		execBench = reRunBench(hFile);

	/* Executa o benchmark */
	if(execBench) 
	{
		/* Copia as informaes do hardware */
		GetSystemInfo(&siSysInfo); 
		/* Coleta o nmero de CPUs da mquina local */
		numProcs = siSysInfo.dwNumberOfProcessors;

		/* Seta bInheritHandle para que os handles dos pipes sejam herdados */
 		saAttr.nLength = sizeof(SECURITY_ATTRIBUTES); 
		saAttr.bInheritHandle = TRUE; 
	    saAttr.lpSecurityDescriptor = NULL; 

		/* Obtm o handle para o STDOUT corrente */
 		hStdout = GetStdHandle(STD_OUTPUT_HANDLE); 
 
		/* Cria um pipe para o STDOUT do processo filho */
		if (! CreatePipe(&hChildStdoutRd, &hChildStdoutWr, &saAttr, 0)) 
			ErrorExit("Falha na criao do Stdout do pipe\n"); 
	  
		/* Garante que o handle de leitura do STDOUT do pipe no  herdado */
		SetHandleInformation( hChildStdoutRd, HANDLE_FLAG_INHERIT, 0);
 
		/* Cria um processo para cada processador da mquina */
		for(int i = 0; i < numProcs; i++) 
		{
			fSuccess = CreateChildProcess(i);
			if (! fSuccess) 
				ErrorExit("Falha na criao do processo"); 
		}

		/* Coleta os resultados dos processos */
		processTime = ReadFromPipe(numProcs);
		
		/* Calcula a capacidade de processamento da CPU */
		processTime /= numProcs;
   		
        result = numProcs * 10000 * 100 / processTime;
	
		if(hFile != INVALID_HANDLE_VALUE)
			CloseHandle(hFile);

		/* Abre o arquivo de sada para escrita */
		hFile = CreateFile(argv[1],     // file to create
			GENERIC_WRITE,              // open for writing
            0,                          // do not share
            NULL,                       // default security
            CREATE_ALWAYS,              // create new file
            FILE_ATTRIBUTE_NORMAL,      // normal file
            NULL);   
		
		/* Escreve resultado no arquivo de sada */
		itoa(result, chBuf, 10);
		fSuccess = WriteFile(hFile, chBuf, (DWORD)strlen(chBuf)*sizeof(char), &dwWritten, NULL); 
		if (! fSuccess) 
			printf("Erro no WriteFile! %d", GetLastError());
	}

	CloseHandle(hFile);

	return 1;
}

/* Determina se o benchmark deve ser executado. Existem dois casos em que isso 
ocorre: quando no h nenhum arquivo de sada de uma execuo anterior, e 
quando h esse arquivo, mas ele  mais velho que 30 dias. Esse segundo caso  
tratado neste mtodo */
BOOL reRunBench(HANDLE hFile)
{
    FILETIME ftCreate, ftAccess, ftWrite;
    SYSTEMTIME stUTCFile, stUTCActual, stFile, stActual;
	long actualDiff, timeDiff, diffTime;
	
    /* Coleta o ltimo acesso para escrita do arquivo encontrado */
    if (!GetFileTime(hFile, &ftCreate, &ftAccess, &ftWrite))
        return TRUE;

	/* Convert a data de ltima escrita em uma data local */
    FileTimeToSystemTime(&ftWrite, &stUTCFile);
    SystemTimeToTzSpecificLocalTime(NULL, &stUTCFile, &stFile);

	/* Obtm a hora atual e a transforma em data local */
	GetSystemTime(&stUTCActual);
	SystemTimeToTzSpecificLocalTime(NULL, &stUTCActual, &stActual);

	/* Calcula a diferena entre os tempos */
	actualDiff = ((stActual.wYear - BASE_YEAR) * 360) + 
		((stActual.wMonth - 1) * 30) + stActual.wDay;

	timeDiff = ((stFile.wYear - BASE_YEAR) * 360) + 
		((stFile.wMonth - 1) * 30) + stFile.wDay;

	diffTime = actualDiff - timeDiff;

	/* Se contedo do arquivo mais antigo que RENEW_BENCH, executa o benchmark 
	novamente */
	if(diffTime > RENEW_BENCH)
		return TRUE;
	else
		return FALSE; 
}

/* Cria um processo filho */
BOOL CreateChildProcess(INT processorMask) 
{ 
	TCHAR szCmdline[]=TEXT("whet");
	PROCESS_INFORMATION piProcInfo; 
	STARTUPINFO siStartInfo;
	BOOL bFuncRetn = FALSE; 
 
	/* Configura os membros da estrutura PROCESS_INFORMATION */
	ZeroMemory( &piProcInfo, sizeof(PROCESS_INFORMATION) );
 
	/* Configura os membros da estrutura STARTUPINFO */
	ZeroMemory( &siStartInfo, sizeof(STARTUPINFO) );
	siStartInfo.cb = sizeof(STARTUPINFO); 
	siStartInfo.hStdError = hChildStdoutWr;
	siStartInfo.hStdOutput = hChildStdoutWr;
	siStartInfo.dwFlags |= STARTF_USESTDHANDLES;
 
    /* Cria, de fato, o processo filho */
	bFuncRetn = CreateProcess(NULL, 
		szCmdline,     // command line 
		NULL,          // process security attributes 
		NULL,          // primary thread security attributes 
		TRUE,          // handles are inherited 
		0,             // creation flags 
		NULL,          // use parent's environment 
		NULL,          // use parent's current directory 
		&siStartInfo,  // STARTUPINFO pointer 
		&piProcInfo);  // receives PROCESS_INFORMATION 
   
    if (bFuncRetn == 0) 
		ErrorExit("Falha na criao do processo filho\n");
    else 
    {
		SetProcessAffinityMask(piProcInfo.hProcess, (int)pow(2,processorMask));
		CloseHandle(piProcInfo.hProcess);
		CloseHandle(piProcInfo.hThread);
		return bFuncRetn;
	}
}
 
/* Metdo que realiza leitura de dados enviados pelos processos filhos para 
o pipe */
LONG ReadFromPipe(INT numProcs) 
{ 
   DWORD dwRead; 
   CHAR chBuf[BUFSIZE]; 
   LONG processTime = 0;

   /* Fecha a opo de escrita para ler o canal */
   if (!CloseHandle(hChildStdoutWr)) 
      ErrorExit("Closing handle failed"); 
 
   /* Captura dados do canal */
   for(int i = 0; i < numProcs; i++) 
   {
		ReadFile( hChildStdoutRd, chBuf, BUFSIZE, &dwRead, NULL);
		processTime += atol(chBuf);
   }
   
   return processTime;
} 
 
/* Mtodo para a exposio de erros */
VOID ErrorExit (LPTSTR lpszMessage) 
{ 
   fprintf(stderr, "%s\n", lpszMessage); 
   ExitProcess(0); 
} 
