#include "wioapiimpl.h"

// Metodos de WIOProject-------------------------------------------------------

WIOProject::~WIOProject() {
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// ...........................................................................
/**
 *
 */
WIOProjectImpl::WIOProjectImpl(wio::WIOProject* wioProject) 
throw (wioapi::Exception*) {
   if (wioProject == NULL) {
      throw new wioapi::Exception("WIOProject::WIOProject()", 
            "Ponteiro nulo detectado!", "");
   }
	this->wioProject = wioProject;
}

// ...........................................................................
/**
 * O ObjVar deleta os attributos devidamente. Nao devemos por delete aqui.
 */
WIOProjectImpl::~WIOProjectImpl() {
   destroy();
}

// ...........................................................................
/**
 *
 */
char* WIOProjectImpl::getId(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::getId()", 
            "Objeto CORBA nulo detectado!", "");
   }
	_TRY(return wioProject->getId(), "WIOProject::getId()");
}
		
// ...........................................................................
/**
 *
 */
char* WIOProjectImpl::getUser(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::getUser()", 
            "Objeto CORBA nulo detectado!", "");
   }
	_TRY(return wioProject->getUser(), "WIOProject::getUser");
}

// ...........................................................................
/**
 *
 */
WIOFile* WIOProjectImpl::getRootFile() const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::getRootFile()", 
            "Objeto CORBA nulo detectado!", "");
   }
	_TRY(
       return new WIOFileImpl(wioProject->getRootFile()), 
       "WIOProjectImpl::getRootFile"
   );
}

// ...........................................................................
/**
 *
 */
WIOFile* WIOProjectImpl::getFile(const char* path) const 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::getFile()", 
            "Objeto CORBA nulo detectado!", "");
   }
	_TRY(
      return new WIOFileImpl(wioProject->getFile(path)),
      "WIOProject::getFile"
	);
}

// ...........................................................................
/**
 *
 */
bool WIOProjectImpl::fileExists(const char* path) const 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::fileExists()", 
            "Objeto CORBA nulo detectado!", "");
   }
	_TRY(
      return booleanToBool(wioProject->fileExists(path)), 
      "WIOProject::fileExists"
   );
}

// ...........................................................................
/**
 *
 */
void WIOProjectImpl::destroy(void) throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::destroy()", 
            "Objeto CORBA nulo detectado!", "");
   }
	_TRY(wioProject->destroy(), "WIOProject::destroy");
}

// ...........................................................................
/**
 *
 */
void WIOProjectImpl::moveFile(const char* fromPath, const char* toPath) 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::moveFile()", 
            "Objeto CORBA nulo detectado!", "");
   }
  _TRY(wioProject->moveFile(fromPath, toPath), "WIOProject::moveFile");
}

// ...........................................................................
/**
 *
 */
void WIOProjectImpl::copyFile(const char* fromPath, const char* toPath) 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::copyFile()", 
            "Objeto CORBA nulo detectado!", "");
   }
  _TRY(wioProject->copyFile(fromPath, toPath), "WIOProject::copyFile");
}

// ..........................................................................
/**
 *
 */
long WIOProjectImpl::getNumOpenedFiles(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::getNumOpenedFiles()", 
            "Objeto CORBA nulo detectado!", "");
   }
  _TRY(return wioProject->getNumOpenedFiles(), "WIOProject::getNumOpenedFiles");
}

// ..........................................................................
/**
 *
 */
long WIOProjectImpl::getMaxOpenedFiles(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::getMaxOpenedFiles()", 
            "Objeto CORBA nulo detectado!", "");
   }
 _TRY( 
     return wioProject->getMaxOpenedFiles(),
     "WIOProject::getMaxOpenedFiles"
  );
}

// ...........................................................................
/**
 *
 */
void WIOProjectImpl::renameFile(const char* path, const char* newName) 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::renameFile()", 
            "Objeto CORBA nulo detectado!", "");
   }
  _TRY(wioProject->renameFile(path, newName), "WIOProject::renameFile");
}

// ...........................................................................
/**
 *
 */
void WIOProjectImpl::deleteFile(const char* path) throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::deleteFile()", 
            "Objeto CORBA nulo detectado!", "");
   }
  _TRY(wioProject->deleteFile(path), "WIOProject::deleteFile");
}

// ...........................................................................
/**
 *
 */
WIOFile* WIOProjectImpl::createFile(const char* path, const char* type,
const char* userId) throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::createFile()", 
            "Objeto CORBA nulo detectado!", "");
   }
	_TRY(
      return new WIOFileImpl(wioProject->createFile(path, type, userId)), 
      "WIOProject::createFile"
   );
}

// ...........................................................................
/**
 *
 */
WIOFile* WIOProjectImpl::createDirectory(const char* path) 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioProject.in())) {
      throw new wioapi::Exception("WIOProject::createDirectory()", 
            "Objeto CORBA nulo detectado!", "");
   }
	_TRY(
      return new WIOFileImpl(wioProject->createDirectory(path)), 
      "WIOProject::createDirectory"
   );
}

