// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------

#include "wioapiimpl.h"

// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------

// --------------------------------------------------------------------------

// ..........................................................................
/**
 * Embora esse destrutor seja virtual em WIOFileSystem,  necessrio
 * implement-lo por que este  chamado pelo destrutor de WIOFileSystemImpl.
 */
WIOFileSystem::~WIOFileSystem() {
}


// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------


// ..........................................................................
/**
 *
 */
WIOFileSystemImpl::WIOFileSystemImpl(char* ior) throw (wioapi::Exception*) {
   wioFileSystem = NULL;
   CORBA::ORB* orb = (CORBA::ORB*) WIOLocator::getORB();

   if (orb == NULL) {
      throw new wioapi::Exception("WIOFileSystem::WIOFileSystem", 
          "ORB nulo!", "No houve chamada ao servidor.");
   }

   if (CORBA::is_nil(orb)) {
      throw new wioapi::Exception("WIOFileSystem::WIOFileSystem", 
          "Sem ORB definido!", "No houve chamada ao servidor.");
   }
   
   if (ior == NULL) {
      throw new wioapi::Exception("WIOFileSystem::WIOFileSystem", 
          "IOR nulo!", "No houve chamada ao servidor.");
   }

   this->ior = strdup(ior);
   // Cria o objeto CORBA atraves da referencia remota.
   try {
     CORBA::Object_var obj = orb->string_to_object(ior);
     if (CORBA::is_nil(obj.in())) {
         throw new wioapi::Exception("WIOFileSystem::WIOFileSystem", 
           "CORBA IOR nulo!", "No houve chamada ao servidor.");
     }
     wioFileSystem = wio::WIOFileSystem::_narrow(obj);
     if (CORBA::is_nil (wioFileSystem.in())) {
         throw new wioapi::Exception("WIOFileSystem::WIOFileSystem", 
           "WIO/FS nulo.", "No houve chamada ao servidor.");
     }
     char *SERVER_VERSION = wioFileSystem->getServerVersion();
     if (strcmp(SERVER_VERSION, wio::WIOFileSystem::VERSION) != 0) {
        static char sbuff[128];
        static char cbuff[128];
        sprintf(sbuff, "Verso do servidor incompatvel (%s)" , SERVER_VERSION);
        sprintf(cbuff, "Verso do cliente incompatvel (%s)" , 
                wio::WIOFileSystem::VERSION);
        throw new wioapi::Exception("WIOFileSystem::WIOFileSystem", cbuff, sbuff);
     }
   }
   catch(CORBA::Exception& ex) {
     cerr << ex << endl;
     throw new wioapi::Exception("WIOFileSystem::WIOFileSystem",
          "Exceo CORBA detectada!", "No houve chamada ao servidor.");
   }
}
   
// ..........................................................................
/**
 * <code>ObjVar</code> deleta os attributos devidamente.
 */
WIOFileSystemImpl::~WIOFileSystemImpl() {
   if (ior != NULL) free(ior);
   ior = NULL;
}
   
// ..........................................................................
/**
 *
 */
char* WIOFileSystemImpl::getIOR(void) {
   return ior;
}

// ..........................................................................
/**
 *
 */
long WIOFileSystemImpl::getMaxOpenedProjects(void) 
const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::getMaxOpenedProjects()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(
       return wioFileSystem->getMaxOpenedProjects(), 
       "WIOFileSystem::getMaxOpenedProjects"
    );
}

// ..........................................................................
/**
 *
 */
long WIOFileSystemImpl::getNumOpenedProjects(void) 
const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::getNumOpenedProjects()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(
       return wioFileSystem->getNumOpenedProjects(), 
       "WIOFileSystem::getNumOpenedProjects"
    );
}

// ..........................................................................
/**
 *
 */
long WIOFileSystemImpl::getMaxReadKb(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::getMaxReadKb()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(
      return wioFileSystem->getMaxReadKb(), 
      "WIOFileSystem::getMaxReadKb"
   );
}

// ..........................................................................
/**
 *
 */
long WIOFileSystemImpl::getMaxWriteKb(void) const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::getMaxWriteKb()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(
      return wioFileSystem->getMaxWriteKb(), 
      "WIOFileSystem::getMaxWriteKb"
   );
}

// ..........................................................................
/**
 *
 */
char* WIOFileSystemImpl::getServerVersion() const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::getServerVersion()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(
      return wioFileSystem->getServerVersion(), 
      "WIOFileSystem::getServerVersion"
   );
}

// ..........................................................................
/**
 *
 */
char* WIOFileSystemImpl::getSeparatorChar() const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::getSeparatorChar()", 
            "Objeto CORBA nulo detectado!", "");
   }
   _TRY(
      return wioFileSystem->getSeparatorChar(), 
      "WIOFileSystem::getSeparatorChar"
   );
}

// ..........................................................................
/**
 *
 */
SharedProjectInfo* WIOFileSystemImpl::getProjectsFromOthers(
const char* userId, const char* passwd, long& qtd) const 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::getProjectsFromOthers()", 
            "Objeto CORBA nulo detectado!", "");
   }

   wio::UserProjects_var projects;
   _TRY(
      projects = wioFileSystem->getProjectsFromOthers(userId, passwd), 
      "WIOFileSystem::getProjectsFromOthers"
   );
   qtd = projects->length();

   SharedProjectInfo* list = new SharedProjectInfo[qtd];
   for (int i = 0; i < qtd; i++) {
      list[i].projectId = strdup((*projects)[i].projectId);
      list[i].ownerId = strdup((*projects)[i].ownerId);
      list[i].ownerName = strdup((*projects)[i].ownerName);
   }
   return list;
}

// ..........................................................................
/**
 *
 */
char** WIOFileSystemImpl::getProjects(const char* userId, 
const char* passwd, long& qtd) const 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::getProjects()", 
            "Objeto CORBA nulo detectado!", "");
   }

   wio::ProjectIds_var projects;
   _TRY(
      projects = wioFileSystem->getProjects(userId, passwd), 
      "WIOFileSystem::getProjects"
   );
   qtd = projects->length();

   char** list = new char*[qtd];
   for (int i=0; i<qtd; i++) {
      // As c_strings com os nomes dos projetos serao deletadas 
      // quando [projects] for deletado (no fim desse mtodo).
      list[i] = new char[strlen((*projects)[i]) + 1];
      strcpy(list[i], (*projects)[i]);
   }

   return list;
}

// ..........................................................................
/**
 *
 */
WIOProject* WIOFileSystemImpl::openProject(const char* userId, 
const char* passwd, const char* projectId) const 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::openProject()", 
            "Objeto CORBA nulo detectado!", "");
   }
   WIOProject* prj = NULL;
   _TRY(
      prj = new WIOProjectImpl(
          wioFileSystem->openProject(userId, passwd, projectId)), 
      "WIOFileSystem::openProject"
   );
   return prj;
}

// ..........................................................................
/**
 *
 */
WIOProject* WIOFileSystemImpl::openProjectFromOthers(const char* userId, 
const char* passwd, const char* ownerId, const char* projectId) const 
throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::openProjectFromOthers()", 
            "Objeto CORBA nulo detectado!", "");
   }
   WIOProject* prj = NULL;
   _TRY(
      prj = new WIOProjectImpl(wioFileSystem->openProjectFromOthers(
            userId, passwd, ownerId, projectId)), 
      "WIOFileSystem::openProjectFromOthers"
   );
   return prj;
}

char* WIOFileSystemImpl::preLogin2Web(const char* login, const char* password, const char* projectName, const WIOAlgorithmInfo& algorithmInfo)
const throw (wioapi::Exception*) {
   if (CORBA::is_nil (wioFileSystem.in())) {
      throw new wioapi::Exception("WIOFileSystem::preLogin2Web()",
            "Objeto CORBA nulo detectado!", "");
   }
   wio::AlgorithmInfo_var info = new wio::AlgorithmInfo();
   info->algorithmName = CORBA::string_dup(algorithmInfo.algorithmName);
   wio::AlgorithmParameters_var parameters = new wio::AlgorithmParameters (algorithmInfo.algorithmParameterAmount);
   parameters->length (algorithmInfo.algorithmParameterAmount);

   for (long i = 0; i < algorithmInfo.algorithmParameterAmount; i++) {
      WIOAlgorithmParameter algorithmParameter = algorithmInfo.algorithmParameters[i];
      MICO_ULong idx = i;
      parameters[idx].name = CORBA::string_dup(algorithmParameter.name);
      parameters[idx].value = CORBA::string_dup(algorithmParameter.value);
   }

   info->parameters = parameters;
   _TRY(
      return wioFileSystem->preLogin2Web(login, password, projectName, info),
      "WIOFileSystem::preLogin2Web"
   );

}
