/*
 * Detalhes da ltima alterao:
 * 
 * $Author$ $Date$ $Revision$
 */
package tecgraf.ftc_1_3.common.logic;

/**
 * Contm o tamanho em bytes dos tipos primitivos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum PrimitiveTypeSize {
  /**
   * Tipo {@link Byte}.
   */
  BYTE(1),
  /**
   * Tipo {@link Short}.
   */
  SHORT(2),
  /**
   * Tipo {@link Integer}.
   */
  INTEGER(4),
  /**
   * Tipo {@link Long}.
   */
  LONG(8);

  /**
   * Tamanho do tipo em bytes.
   */
  private int size;

  /**
   * Constri um tipo.
   * 
   * @param size O tamanho do tipo em bytes.
   */
  private PrimitiveTypeSize(int size) {
    this.size = size;
  }

  /**
   * Obtm o tamanho do tipo em bytes.
   * 
   * @return O tamanho do tipo em bytes.
   */
  public int getSize() {
    return this.size;
  }
}
