/**
 * $Id: FileChannelRequestInfo.java 88412 2009-02-13 22:13:31Z vfusco $
 */
package tecgraf.ftc_1_3.server;

/**
 * Representa informaes sobre a requisio de um canal de dados.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileChannelRequestInfo {
  /**
   * O requisitante.
   */
  private Object requester;
  /**
   * O identificador do arquivo solicitado.
   */
  private byte[] fileId;
  /**
   * Indica se o metodo FileChannel.transferTo pode se utilizado. (Ex.: Em um
   * dispositivo do tipo /dev/zero nao se pode usar esse metodo)
   */
  private boolean useTransferTo = true;

  /**
   * Marca o tempo de criao desta requisio.
   */
  private long creationTime;

  /**
   * Cria informaes sobre a requisio de um canal de dados.
   * 
   * @param requester O requisitante.
   * @param fileId O identificador do arquivo solicitado.
   */
  FileChannelRequestInfo(Object requester, byte[] fileId) {
    this.requester = requester;
    this.fileId = fileId;
    this.creationTime = System.currentTimeMillis();
  }

  /**
   * Obtm o requisitante.
   * 
   * @return O requisitante.
   */
  public Object getRequester() {
    return this.requester;
  }

  /**
   * Obtm o identificador do arquivo solicitado.
   * 
   * @return O identificador do arquivo solicitado.
   */
  public byte[] getFileId() {
    return this.fileId;
  }

  /**
   * Retorna Indicador se o arquivo  normal
   * 
   * @return isNormalFile
   */
  public boolean useTransferTo() {
    return useTransferTo;
  }

  /**
   * @param isNormalFile define se o arquivo  normal.
   */
  public void useTransferTo(boolean isNormalFile) {
    this.useTransferTo = isNormalFile;
  }

  /**
   * Retorna a hora de criao desse objeto.
   * 
   * @return hora de criao em milisegundos
   */
  public long getCreationTime() {
    return creationTime;
  }
}
