/**
 * $Id$
 */
package tecgraf.ftc_1_3.server;

import java.util.logging.Level;

/**
 * Interface que representa configuraes utilizadas no FileServer.
 * 
 * @author Tecgraf
 */
public interface FileServerConfig {

  /**
   * Retorna O nome do host para o servidor de arquivos.
   * 
   * @return hostName
   */
  public String getHostName();

  /**
   * @param hostName O nome do host para o servidor de arquivos.
   */
  public void setHostName(String hostName);

  /**
   * Retorna a porta para o servidor de arquivos.
   * 
   * @return port A porta para o servidor de arquivos.
   */
  public int getPort();

  /**
   * @param port A porta para o servidor de arquivos. Caso seja {@literal 0},
   *        uma porta disponvel ser obtida.
   */
  public void setPort(int port);

  /**
   * Retorna Tempo maximo de espera do metodo select em milisegundos.
   * 
   * @return selectTimeout
   */
  public long getSelectTimeout();

  /**
   * @param selectTimeout Tempo maximo de espera do metodo select em
   *        milisegundos.
   */
  public void setSelectTimeout(long selectTimeout);

  /**
   * Retorna o timeout para o consumo de uma requisio. Aps a criao de um
   * canal o cliente tem X milisegundos para se conectar ao servidor, apos esse
   * tempo a requisio  removida.
   * 
   * @return selectTimeout
   */
  public long getChannelRequestTimeout();

  /**
   * Define o timeout para o consumo de uma requisio. Aps a criao de um
   * canal o cliente tem X milisegundos para se conectar ao servidor, apos esse
   * tempo a requisio  removida.
   * 
   * @param value Tempo maximo que o servidor espera para remover uma channel
   *        nao consumido em milisegundos
   */
  public void setChannelRequestTimeout(long value);

  /**
   * Retorna o timeout para conexes com o cliente (em milisegundos)
   * 
   * @return clientTimeout timeout em milisegundos
   */
  public long getClientTimeout();

  /**
   * Define o timeout das conexes com o cliente (em milisegundos).
   * 
   * @param clientTimeout timeout em milisegundos
   */
  public void setClientTimeout(long clientTimeout);

  /**
   * Retorna O numero maximo de clientes
   * 
   * @return maxClients
   */
  public int getMaxClients();

  /**
   * @param maxClients O numero maximo de clientes
   */
  public void setMaxClients(int maxClients);

  /**
   * Retorna o nmero maximo de requisicoes por canal que o cdigo cliente da
   * biblioteca pode criar sem que as requisioes sejam consumidas.
   * 
   * @return Numero maximo de requisies.
   */
  public int getMaxChannelRequests();

  /**
   * Define o nmero maximo de requisicoes por canal que o cdigo cliente da
   * biblioteca pode criar sem que as requisioes sejam consumidas.
   * 
   * @param maxChannelRequests Nmero maximo de requisioes.
   */
  public void setMaxChannelRequests(int maxChannelRequests);

  /**
   * Retorna Tamanho do espao de memoria utilizado na comunicaao com cada
   * cliente.
   * 
   * @return clientBufferSize
   */
  public int getClientBufferSize();

  /**
   * @param clientBufferSize Define o tamanho do espao de memoria utilizado na
   *        comunicaao com cada cliente.
   */
  public void setClientBufferSize(int clientBufferSize);

  /**
   * Retora o valor da politica de aceitao de novos clientes. True para
   * aceitar o numero maximo de clientes e false para aceitar um cliente por
   * vez.
   * 
   * @return boolean
   */
  public boolean acceptMaxPossible();

  /**
   * Define a politica de aceitao de novos clientes. True para aceitar o
   * numero maximo de clientes e false para aceitar um cliente por vez.
   * 
   * @param value
   */
  public void setAcceptMaxPossible(boolean value);

  /**
   * Retorna True se o servidor deve executar em modo de teste.
   * 
   * @return testMode
   */
  public boolean isTestMode();

  /**
   * Define se o servidor deve executar em modo de teste.
   * 
   * @param testMode
   */
  public void setTestMode(boolean testMode);

  /**
   * Define o nvel de logging. O FTC utiliza java.util.logging.
   * 
   * @param loglevel
   */
  public void setLoglevel(Level loglevel);

  /**
   * Define o nome do arquivo de saida que sera gravado o log. O FTC utiliza
   * java.util.logging.
   * 
   * @param logFileName Nome do arquivo de log
   */
  public void setOutputLogFilename(String logFileName);

  /**
   * @return O nivel de logging. O FTC utiliza java.util.logging.
   */
  public Level getLoglevel();

  /**
   * @return O nome do arquivo de saida que sera gravado o log.
   */
  public String getOutputLogFilename();

}
