/**
 * $Id$
 */
package tecgraf.ftc_1_3.server;

import java.util.logging.Level;

/**
 * Classe responsavel por armazenar as configuraes utilizadas no FileServer.
 * 
 * @author Tecgraf
 */
public class FileServerConfigImpl implements FileServerConfig {
  /**
   * O nome da mquina do servidor de arquivos.
   */
  private String hostName = "0.0.0.0";
  /**
   * A porta do servidor de arquivos.
   */
  private int port = 25555;

  /**
   * Tempo maximo de espera do metodo select em milisegundos.
   */
  private long selectTimeout = 5000;

  /**
   * Tempo maximo de inatividade por cliente.
   */
  private long clientTimeout = 70000;

  /**
   * Numero maximo de clientes simultaneos.
   */
  private int maxClients = 150;

  /**
   * Tamanho do espao de memoria utilizado na comunicaao com cada cliente.
   */
  private int clientBufferSize = 1024 * 1024;

  /**
   * Politica de aceitao de novas conexoes.
   */
  private boolean acceptMaxPossible = false;

  /**
   * Define se o servidor deve executar em modo de teste.
   */
  private boolean testMode = false;

  /**
   * O nvel de logging messages
   */
  private Level loglevel = Level.OFF;

  /**
   * Nome do arquivo de log
   */
  private String logFilename = "./fileserver.log";

  /**
   * Tempo maximo que o servidor espera para remover uma channel nao consumido
   * em milisegundos. (Default = 6 minutos)
   */
  private long channelRequestTimeout = 360000;

  /**
   * Nmero maximo de requisicoes por canal que o cdigo cliente da biblioteca
   * pode criar sem que as requisioes sejam consumidas.
   */
  private int maxChannelRequests = 2048;

  /**
   * Retorna O nome do host para o servidor de arquivos.
   * 
   * @return hostName
   */
  public String getHostName() {
    return hostName;
  }

  /**
   * @param hostName O nome do host para o servidor de arquivos.
   */
  public void setHostName(String hostName) {
    this.hostName = hostName;
  }

  /**
   * Retorna a porta para o servidor de arquivos.
   * 
   * @return port A porta para o servidor de arquivos.
   */
  public int getPort() {
    return port;
  }

  /**
   * @param port A porta para o servidor de arquivos. Caso seja {@literal 0},
   *        uma porta disponvel ser obtida.
   */
  public void setPort(int port) {
    this.port = port;
  }

  /**
   * Retorna Tempo maximo de espera do metodo select em milisegundos.
   * 
   * @return selectTimeout
   */
  public long getSelectTimeout() {
    return selectTimeout;
  }

  /**
   * @param selectTimeout Tempo maximo de espera do metodo select em
   *        milisegundos.
   */
  public void setSelectTimeout(long selectTimeout) {
    this.selectTimeout = selectTimeout;
  }

  /**
   * Retorna
   * 
   * @return clientTimeout
   */
  public long getClientTimeout() {
    return clientTimeout;
  }

  /**
   * @param clientTimeout
   */
  public void setClientTimeout(long clientTimeout) {
    this.clientTimeout = clientTimeout;
  }

  /**
   * Retorna O numero maximo de clientes
   * 
   * @return maxClients
   */
  public int getMaxClients() {
    return maxClients;
  }

  /**
   * @param maxClients O numero maximo de clientes
   */
  public void setMaxClients(int maxClients) {
    this.maxClients = maxClients;
  }

  /**
   * Retorna Tamanho do espao de memoria utilizado na comunicaao com cada
   * cliente.
   * 
   * @return clientBufferSize
   */
  public int getClientBufferSize() {
    return clientBufferSize;
  }

  /**
   * @param clientBufferSize Define o tamanho do espao de memoria utilizado na
   *        comunicaao com cada cliente.
   */
  public void setClientBufferSize(int clientBufferSize) {
    this.clientBufferSize = clientBufferSize;
  }

  /**
   * Retora o valor da politica de aceitao de novos clientes. True para
   * aceitar o numero maximo de clientes e false para aceitar um cliente por
   * vez.
   * 
   * @return boolean
   */
  public boolean acceptMaxPossible() {
    return acceptMaxPossible;
  }

  /**
   * Define a politica de aceitao de novos clientes. True para aceitar o
   * numero maximo de clientes e false para aceitar um cliente por vez.
   * 
   * @param value
   */
  public void setAcceptMaxPossible(boolean value) {
    acceptMaxPossible = value;
  }

  /**
   * Retorna True se o servidor deve executar em modo de teste.
   * 
   * @return testMode
   */
  public boolean isTestMode() {
    return testMode;
  }

  /**
   * Define se o servidor deve executar em modo de teste.
   * 
   * @param testMode
   */
  public void setTestMode(boolean testMode) {
    this.testMode = testMode;
  }

  /**
   * Define o nvel de logging
   * 
   * @param loglevel
   */
  public void setLoglevel(Level loglevel) {
    this.loglevel = loglevel;
  }

  /**
   * @return O nivel de logging
   */
  public Level getLoglevel() {
    return loglevel;
  }

  /**
   * Define o nome do arquivo de saida do log.
   * 
   * @param filename
   */
  public void setOutputLogFilename(String filename) {
    if (filename != null)
      this.logFilename = filename;
  }

  /**
   * {@inheritDoc}
   */
  public String getOutputLogFilename() {
    return logFilename;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public long getChannelRequestTimeout() {
    return channelRequestTimeout;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setChannelRequestTimeout(long value) {
    channelRequestTimeout = value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getMaxChannelRequests() {
    return maxChannelRequests;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setMaxChannelRequests(int maxChannelRequests) {
    this.maxChannelRequests = maxChannelRequests;
  }
}
