/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_3.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import tecgraf.ftc_1_3.client.RemoteFileChannel;
import tecgraf.ftc_1_3.common.exception.FailureException;
import tecgraf.ftc_1_3.common.exception.FileLockedException;
import tecgraf.ftc_1_3.common.exception.InvalidProtocolVersionException;
import tecgraf.ftc_1_3.common.exception.MaxClientsReachedException;
import tecgraf.ftc_1_3.common.exception.PermissionException;
import tecgraf.ftc_1_3.common.logic.ErrorCode;
import tecgraf.ftc_1_3.common.logic.Operation;
import tecgraf.ftc_1_3.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_3.utils.ByteBufferUtils;

public final class RemoteFileChannelImpl
implements RemoteFileChannel {
    private String host;
    private int port;
    private byte[] key;
    private byte[] identifier;
    private boolean writable;
    private boolean open = false;
    private boolean readOnly;
    private SocketChannel channel;
    private ByteBuffer buffer;
    private int bufferSize = 0x100000;

    public RemoteFileChannelImpl(byte[] identifier, boolean writable, String host, int port, byte[] key) {
        this.host = host;
        this.port = port;
        this.key = key;
        this.identifier = identifier;
        this.writable = writable;
    }

    @Override
    public void open(boolean readOnly) throws PermissionException, FileNotFoundException, FailureException, MaxClientsReachedException, InvalidProtocolVersionException {
        if (!readOnly && !this.writable) {
            throw new PermissionException("O arquivo n\u00e3o pode ser aberto para escrita.");
        }
        try {
            this.channel = SocketChannel.open(new InetSocketAddress(this.host, this.port));
            this.channel.socket().setTcpNoDelay(true);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        this.protocolVersionHandshake();
        this.authenticate();
        Operation operation = readOnly ? Operation.OPEN_READ_ONLY : Operation.OPEN_READ_WRITE;
        ErrorCode errorCode = null;
        try {
            this.buffer.put(operation.getCode());
            ByteBufferUtils.writeBytes(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), this.identifier);
            errorCode = this.readReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        if (!ErrorCode.OK.equals((Object)errorCode)) {
            this.release();
            if (errorCode.equals((Object)ErrorCode.FILE_NOT_FOUND)) {
                throw new FileNotFoundException("O arquivo n\u00e3o existe.");
            }
            if (errorCode.equals((Object)ErrorCode.NO_PERMISSION)) {
                throw new PermissionException("Sem permiss\u00e3o para abrir o arquivo.");
            }
            if (errorCode.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha no servidor ao tentar abrir o arquivo.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)errorCode));
        }
        this.open = true;
        this.readOnly = readOnly;
    }

    private void protocolVersionHandshake() throws FailureException, PermissionException, MaxClientsReachedException, InvalidProtocolVersionException {
        ErrorCode errorCode = null;
        try {
            long idAndVersion = 4609091L;
            idAndVersion <<= 32;
            int major = 1;
            int minor = 2;
            int patch = 0;
            ByteBufferUtils.writeLong(this.buffer, this.channel, idAndVersion |= (long)(major << 16 | minor << 8 | patch));
            errorCode = this.readReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        if (!ErrorCode.OK.equals((Object)errorCode)) {
            this.release();
            if (errorCode.equals((Object)ErrorCode.INVALID_VERSION)) {
                throw new InvalidProtocolVersionException("Servidor n\u00e3o suporta esta vers\u00e3o do protocolo.");
            }
            if (errorCode.equals((Object)ErrorCode.MAX_CLIENTS_REACHED)) {
                throw new MaxClientsReachedException("N\u00famero m\u00e1ximo de clientes no servidor atingido.");
            }
            if (errorCode.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha ao negociar protocolo com o servidor.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)errorCode));
        }
    }

    private void authenticate() throws FailureException, PermissionException, MaxClientsReachedException {
        ErrorCode errorCode = null;
        try {
            ByteBufferUtils.writeBytes(this.buffer, this.channel, this.key);
            errorCode = this.readReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        if (!ErrorCode.OK.equals((Object)errorCode)) {
            this.release();
            if (errorCode.equals((Object)ErrorCode.INVALID_KEY)) {
                throw new PermissionException("Chave de acesso inv\u00e1lida.");
            }
            if (errorCode.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha no servidor ao tentar se autenticar com a chave fornecida.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)errorCode));
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws FailureException {
        if (this.channel == null) {
            throw new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel fechar um arquivo que n\u00e3o foi aberto.");
        }
        this.open = false;
        ErrorCode errorCode = ErrorCode.FAILURE;
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.CLOSE.getCode());
            errorCode = this.readReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        this.release();
        if (ErrorCode.FAILURE.equals((Object)errorCode)) {
            throw new FailureException("Falha no fechamento do canal do arquivo.");
        }
    }

    private ErrorCode readReturnCode() throws IOException {
        byte code = ByteBufferUtils.readByte(this.buffer, this.channel);
        ErrorCode errorCode = ErrorCode.valueOf(code);
        this.buffer.clear();
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.open = false;
            this.buffer = null;
            this.channel = null;
        }
    }

    @Override
    public void setSize(long size) throws PermissionException, FailureException {
        if (this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.SET_SIZE.getCode());
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), size);
            ErrorCode errorCode = this.readReturnCode();
            if (!ErrorCode.OK.equals((Object)errorCode)) {
                throw new FailureException("Falha ao alterar o tamanho do arquivo.");
            }
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    @Override
    public long getPosition() throws FailureException {
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.GET_POSITION.getCode());
            ErrorCode errorCode = this.readReturnCode();
            if (!errorCode.equals((Object)ErrorCode.OK)) {
                throw new FailureException("Falha ao ler posi\u00e7\u00e3o do arquivo.");
            }
            long pos = ByteBufferUtils.readLong(this.buffer, this.channel);
            return pos;
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    @Override
    public void setPosition(long position) throws FailureException {
        try {
            this.buffer.put(Operation.SET_POSITION.getCode());
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), position);
            ErrorCode errorCode = this.readReturnCode();
            if (!ErrorCode.OK.equals((Object)errorCode)) {
                throw new FailureException("Falha ao alterar o tamanho do arquivo.");
            }
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    @Override
    public long getSize() throws FailureException {
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.GET_SIZE.getCode());
            ErrorCode errorCode = this.readReturnCode();
            if (!errorCode.equals((Object)ErrorCode.OK)) {
                throw new FailureException("Falha ao ler tamanho do arquivo");
            }
            long size = ByteBufferUtils.readLong(this.buffer, this.channel);
            return size;
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    @Override
    public int read(byte[] target) throws FailureException {
        return this.read(target, 0, target.length, -1L);
    }

    @Override
    public int read(byte[] target, long position) throws FailureException {
        return this.read(target, 0, target.length, position);
    }

    @Override
    public int read(byte[] target, int offset, int length) throws FailureException {
        return this.read(target, offset, length, -1L);
    }

    @Override
    public int read(byte[] target, int offset, int length, long position) throws FailureException {
        int totalBytesRead;
        int bytesRead;
        if (offset < 0 || length < 0 || offset + length > target.length) {
            throw new FailureException("Parametros do READ invalidos.");
        }
        ByteBuffer dstBuffer = ByteBuffer.wrap(target, offset, length);
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(position);
        this.buffer.putLong(length);
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        finally {
            this.buffer.clear();
        }
        for (totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            try {
                int missingBytes;
                ErrorCode errorCode = this.readReturnCode();
                if (errorCode.equals((Object)ErrorCode.END_OF_FILE)) {
                    if (totalBytesRead == 0) {
                        return -1;
                    }
                    return totalBytesRead;
                }
                if (!errorCode.equals((Object)ErrorCode.OK)) {
                    throw new FailureException("Falha ao tentar ler arquivo");
                }
                long chunkSize = ByteBufferUtils.readLong(this.buffer, this.channel);
                int limit = chunkSize < (long)(missingBytes = length - totalBytesRead) ? (int)chunkSize : missingBytes;
                dstBuffer.limit(dstBuffer.position() + limit);
                bytesRead = 0;
                int readCount = 0;
                while ((long)bytesRead < chunkSize) {
                    readCount = this.channel.read(dstBuffer);
                    if (readCount < 0) {
                        throw new FailureException("Falha ao tentar ler dados do canal");
                    }
                    bytesRead += readCount;
                }
                continue;
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
        }
        return totalBytesRead;
    }

    @Override
    public int write(byte[] source) throws PermissionException, FailureException, FileLockedException {
        return this.write(source, 0, source.length, -1L);
    }

    @Override
    public int write(byte[] source, long position) throws PermissionException, FailureException, FileLockedException {
        return this.write(source, 0, source.length, position);
    }

    @Override
    public int write(byte[] source, int offset, int length) throws PermissionException, FailureException, FileLockedException {
        return this.write(source, offset, length, -1L);
    }

    @Override
    public int write(byte[] source, int offset, int length, long position) throws PermissionException, FailureException, FileLockedException {
        if (this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(position);
        ErrorCode errorCode = ErrorCode.FAILURE;
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), length);
            errorCode = this.readReturnCode();
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        if (ErrorCode.FILE_LOCKED.equals((Object)errorCode)) {
            throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
        }
        if (ErrorCode.READ_ONLY.equals((Object)errorCode)) {
            throw new PermissionException("Arquivo esta aberto somente para leitura.");
        }
        if (!ErrorCode.OK.equals((Object)errorCode)) {
            throw new FailureException("Falha ao tentar escrever no arquivo");
        }
        ByteBuffer dstBuffer = ByteBuffer.wrap(source, offset, length);
        try {
            int bytesWritten = 0;
            while ((bytesWritten += this.channel.write(dstBuffer)) < length) {
            }
            return bytesWritten;
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    @Override
    public long transferTo(long position, long count, OutputStream outputStream) throws FailureException {
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(position);
        this.buffer.putLong(count);
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        finally {
            this.buffer.clear();
        }
        long bytesWrittenTotal = 0L;
        long currentChunkSize = 0L;
        int chunkReadBytes = 0;
        int bytesRead = 0;
        while (bytesWrittenTotal < count) {
            try {
                ErrorCode errorCode = this.readReturnCode();
                if (errorCode.equals((Object)ErrorCode.END_OF_FILE)) {
                    this.buffer.clear();
                    if (bytesWrittenTotal == 0L) {
                        return -1L;
                    }
                    return bytesWrittenTotal;
                }
                if (!errorCode.equals((Object)ErrorCode.OK)) {
                    throw new FailureException("Falha ao tentar ler arquivo");
                }
                currentChunkSize = ByteBufferUtils.readLong(this.buffer, this.channel);
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
            chunkReadBytes = 0;
            while ((long)chunkReadBytes < currentChunkSize) {
                this.buffer.clear();
                this.buffer.limit((int)(currentChunkSize - (long)chunkReadBytes));
                try {
                    bytesRead = this.channel.read(this.buffer);
                    if (bytesRead < 0) {
                        throw new FailureException("Falha ao tentar ler dados do canal");
                    }
                    outputStream.write(this.buffer.array(), 0, bytesRead);
                }
                catch (IOException e) {
                    throw new FailureException(e);
                }
                bytesWrittenTotal += (long)bytesRead;
                chunkReadBytes += bytesRead;
            }
            this.buffer.clear();
        }
        this.buffer.clear();
        return bytesWrittenTotal;
    }

    @Override
    public long transferTo(long position, long count, RemoteFileChannel target) throws FailureException, PermissionException, FileLockedException {
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(position);
        this.buffer.putLong(count);
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        finally {
            this.buffer.clear();
        }
        long bytesWrittenTotal = 0L;
        long currentChunkSize = 0L;
        long chunkReadBytes = 0L;
        int bytesRead = 0;
        while (bytesWrittenTotal < count) {
            try {
                ErrorCode errorCode = this.readReturnCode();
                if (errorCode.equals((Object)ErrorCode.END_OF_FILE)) {
                    if (bytesWrittenTotal == 0L) {
                        return -1L;
                    }
                    return bytesWrittenTotal;
                }
                if (!errorCode.equals((Object)ErrorCode.OK)) {
                    throw new FailureException("Falha ao tentar ler arquivo");
                }
                currentChunkSize = ByteBufferUtils.readLong(this.buffer, this.channel);
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
            for (chunkReadBytes = 0L; chunkReadBytes < currentChunkSize; chunkReadBytes += (long)bytesRead) {
                this.buffer.clear();
                this.buffer.limit((int)(currentChunkSize - chunkReadBytes));
                try {
                    bytesRead = this.channel.read(this.buffer);
                    if (bytesRead < 0) {
                        throw new FailureException("Falha ao tentar ler dados do canal");
                    }
                    this.buffer.flip();
                    target.write(this.buffer.array(), 0, bytesRead);
                }
                catch (IOException e) {
                    throw new FailureException(e);
                }
                bytesWrittenTotal += (long)bytesRead;
            }
            this.buffer.clear();
        }
        this.buffer.clear();
        return bytesWrittenTotal;
    }

    @Override
    public long transferFrom(InputStream source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        if (this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(position);
        ErrorCode errorCode = ErrorCode.FAILURE;
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
            errorCode = this.readReturnCode();
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        if (ErrorCode.FILE_LOCKED.equals((Object)errorCode)) {
            throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
        }
        byte[] bufferArray = this.buffer.array();
        long bytesReadTotal = 0L;
        while (bytesReadTotal < count) {
            int bytesRead;
            int len = bufferArray.length;
            if ((long)bufferArray.length > count - bytesReadTotal) {
                len = (int)(count - bytesReadTotal);
            }
            try {
                bytesRead = source.read(bufferArray, 0, len);
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
            if (bytesRead == -1) break;
            bytesReadTotal += (long)bytesRead;
            this.buffer.limit(bytesRead);
            int bytesWrittenTotal = 0;
            while (this.buffer.hasRemaining()) {
                try {
                    int bytesWritten = this.channel.write(this.buffer);
                    if (bytesWritten < 0) {
                        throw new IllegalStateException();
                    }
                    bytesWrittenTotal += bytesWritten;
                }
                catch (IOException e) {
                    this.buffer.clear();
                    throw new FailureException(e);
                }
            }
            this.buffer.clear();
        }
        return bytesReadTotal;
    }

    @Override
    public long transferFrom(RemoteFileChannel source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        if (this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(position);
        ErrorCode errorCode = ErrorCode.FAILURE;
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
            errorCode = this.readReturnCode();
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        if (ErrorCode.FILE_LOCKED.equals((Object)errorCode)) {
            throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
        }
        byte[] bufferArray = this.buffer.array();
        long bytesReadTotal = 0L;
        while (bytesReadTotal < count) {
            int len = bufferArray.length;
            if ((long)bufferArray.length > count - bytesReadTotal) {
                len = (int)(count - bytesReadTotal);
            }
            int bytesRead = source.read(bufferArray, 0, len);
            bytesReadTotal += (long)bytesRead;
            this.buffer.limit(bytesRead);
            int bytesWrittenTotal = 0;
            while (this.buffer.hasRemaining()) {
                try {
                    int bytesWritten = this.channel.write(this.buffer);
                    if (bytesWritten < 0) {
                        throw new IllegalStateException();
                    }
                    bytesWrittenTotal += bytesWritten;
                }
                catch (IOException e) {
                    this.buffer.clear();
                    throw new FailureException(e);
                }
            }
            this.buffer.clear();
        }
        return bytesReadTotal;
    }

    @Override
    public void keepAlive() throws FailureException {
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.KEEP_ALIVE.getCode());
            ErrorCode errorCode = this.readReturnCode();
            if (!ErrorCode.OK.equals((Object)errorCode)) {
                throw new FailureException("Erro na opera\u00e7\u00e3o Keep Alive");
            }
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

