/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_3.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import tecgraf.ftc_1_3.common.logic.PrimitiveTypeSize;

public final class ByteBufferUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readLong(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        buffer.limit(PrimitiveTypeSize.LONG.getSize());
        int nbytes = 0;
        try {
            while ((nbytes = channel.read(buffer)) != -1 && buffer.hasRemaining()) {
            }
            if (buffer.hasRemaining()) {
                long l = -1L;
                return l;
            }
            buffer.flip();
            long l = buffer.getLong();
            return l;
        }
        finally {
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte readByte(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        int nbytes = 0;
        try {
            while ((nbytes = channel.read(buffer)) != -1 && buffer.hasRemaining()) {
            }
            if (buffer.hasRemaining()) {
                byte by = -1;
                return by;
            }
            buffer.flip();
            byte by = buffer.get();
            return by;
        }
        finally {
            buffer.clear();
        }
    }

    public static void writeByte(ByteBuffer buffer, WritableByteChannel channel, byte value) throws IOException {
        ByteBufferUtils.writeByte(buffer, channel, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByte(ByteBuffer buffer, WritableByteChannel channel, int extraBytes, byte value) throws IOException {
        buffer.put(value);
        buffer.flip();
        try {
            int bytesWritten = 0;
            while ((bytesWritten += channel.write(buffer)) < PrimitiveTypeSize.BYTE.getSize() + extraBytes) {
            }
        }
        finally {
            buffer.clear();
        }
    }

    public static void writeLong(ByteBuffer buffer, WritableByteChannel channel, long value) throws IOException {
        ByteBufferUtils.writeLong(buffer, channel, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLong(ByteBuffer buffer, WritableByteChannel channel, int extraBytes, long value) throws IOException {
        buffer.putLong(value);
        buffer.flip();
        try {
            int bytesWritten = 0;
            while ((bytesWritten += channel.write(buffer)) < PrimitiveTypeSize.LONG.getSize() + extraBytes) {
            }
        }
        finally {
            buffer.clear();
        }
    }

    public static void writeBytes(ByteBuffer buffer, WritableByteChannel channel, byte[] value) throws IOException {
        ByteBufferUtils.writeBytes(buffer, channel, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(ByteBuffer buffer, WritableByteChannel channel, int extraBytes, byte[] value) throws IOException {
        buffer.put((byte)value.length);
        buffer.put(value);
        buffer.flip();
        int bytesWritten = 0;
        try {
            while ((bytesWritten += channel.write(buffer)) < value.length + extraBytes) {
            }
        }
        finally {
            buffer.clear();
        }
    }
}

