/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The columns of elements that a table may contain.")
public class ColumnOfElements {
    private String id = null;
    private String header = null;
    private Object defaultValue = null;
    private ElementTypeEnum elementType = null;

    public ColumnOfElements id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The identification of the column")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ColumnOfElements header(String header) {
        this.header = header;
        return this;
    }

    @ApiModelProperty(value="the header of the column")
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public ColumnOfElements defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @ApiModelProperty(value="A json object that is the default value for this parameter. It depends of the parameter type.")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ColumnOfElements elementType(ElementTypeEnum elementType) {
        this.elementType = elementType;
        return this;
    }

    @ApiModelProperty(value="The type of the element")
    public ElementTypeEnum getElementType() {
        return this.elementType;
    }

    public void setElementType(ElementTypeEnum elementType) {
        this.elementType = elementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnOfElements columnOfElements = (ColumnOfElements)o;
        return Objects.equals(this.id, columnOfElements.id) && Objects.equals(this.header, columnOfElements.header) && Objects.equals(this.defaultValue, columnOfElements.defaultValue) && Objects.equals((Object)this.elementType, (Object)columnOfElements.elementType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.header, this.defaultValue, this.elementType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColumnOfElements {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    elementType: ").append(this.toIndentedString((Object)this.elementType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ElementTypeEnum {
        INTEGER("Integer"),
        DOUBLE("Double"),
        BOOLEAN("Boolean"),
        STRING("String"),
        UNSUPPORTED("Unsupported");

        private String value;

        private ElementTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

