/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.adapter.algorithm.v1;

import ibase.rest.adapter.algorithm.v1.BooleanParameterFactory;
import ibase.rest.adapter.algorithm.v1.DoubleParameterFactory;
import ibase.rest.adapter.algorithm.v1.EnumerationParameterFactory;
import ibase.rest.adapter.algorithm.v1.InputFileParameterFactory;
import ibase.rest.adapter.algorithm.v1.IntegerParameterFactory;
import ibase.rest.adapter.algorithm.v1.OutputFileParameterFactory;
import ibase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.adapter.algorithm.v1.StringParameterFactory;
import ibase.rest.adapter.algorithm.v1.UnsupportedParameterFactory;
import java.util.HashMap;
import java.util.Map;

public class ParameterMapper {
    private Map<String, ParameterFactory> map;

    public ParameterMapper() {
        this.load();
    }

    private void load() {
        this.map = new HashMap<String, ParameterFactory>();
        this.map.put("INTEGER", new IntegerParameterFactory());
        this.map.put("LIST_OF_INTEGERS", new IntegerParameterFactory());
        this.map.put("BOOLEAN", new BooleanParameterFactory());
        this.map.put("DOUBLE", new DoubleParameterFactory());
        this.map.put("LIST_OF_DOUBLES", new DoubleParameterFactory());
        this.map.put("TEXT", new StringParameterFactory());
        this.map.put("LIST_OF_TEXTS", new StringParameterFactory());
        this.map.put("INPUT_FILE", new InputFileParameterFactory());
        this.map.put("INPUT_FILE", new InputFileParameterFactory());
        this.map.put("OUTPUT_FILE", new OutputFileParameterFactory());
        this.map.put("OUTPUT_FILE", new OutputFileParameterFactory());
        this.map.put("ENUMERATION_LIST", new EnumerationParameterFactory());
        this.map.put("ENUMERATION", new EnumerationParameterFactory());
    }

    public ParameterFactory getFactoryFor(String type) {
        System.out.println("Type =" + type);
        ParameterFactory factory = this.map.get(type);
        if (factory == null) {
            factory = new UnsupportedParameterFactory();
        }
        return factory;
    }
}

