/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.adapter.execution_node.v1;

import csbase.logic.SGASet;
import csbase.logic.sga.filter.SGACriteria;
import csbase.logic.sga.filter.SGACriteriaAnd;
import csbase.logic.sga.filter.SGACriteriaByAvailability;
import csbase.logic.sga.filter.SGACriteriaByMinCPUs;
import csbase.logic.sga.filter.SGACriteriaByMinFreeRAMMem;
import csbase.logic.sga.filter.SGACriteriaByPlatform;
import csbase.logic.sga.filter.SGACriteriaByRequirements;
import csbase.logic.sga.filter.SGACriteriaOr;
import csbase.logic.sga.filter.SGAFilter;
import ibase.common.JsonUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class FilterByJsonRequirements {
    private static final String PLATFORMS_KEY = "csbase_platforms";
    private static final String CPU_AMMOUNT_KEY = "csbase_cpu";
    private static final String MEMORY_AMMOUNT_KEY = "csbase_memory";
    private Map<String, Object> requirements = new HashMap<String, Object>();

    public FilterByJsonRequirements(String requirements) {
        if (requirements == null) {
            return;
        }
        JsonObject object = JsonUtil.jsonFromString((String)requirements);
        this.requirements = JsonUtil.jsonToMap((JsonObject)object);
    }

    public List<SGASet> filter(List<SGASet> servers) {
        SGACriteriaOr platformsCriteria = null;
        SGACriteriaByAvailability availabilityCriteria = null;
        SGACriteriaByMinCPUs minCPUsCriteria = null;
        SGACriteriaByMinFreeRAMMem minMemCriteria = null;
        SGACriteriaByRequirements aditionalCriteria = null;
        List platformsSet = (List)this.requirements.get(PLATFORMS_KEY);
        this.requirements.remove(PLATFORMS_KEY);
        if (platformsSet != null) {
            LinkedList<SGACriteriaByPlatform> criterias = new LinkedList<SGACriteriaByPlatform>();
            for (JsonString platform : platformsSet) {
                criterias.add(new SGACriteriaByPlatform(platform.getString()));
            }
            platformsCriteria = new SGACriteriaOr(criterias);
        }
        JsonNumber minCPU = (JsonNumber)this.requirements.get(CPU_AMMOUNT_KEY);
        this.requirements.remove(CPU_AMMOUNT_KEY);
        if (minCPU != null) {
            minCPUsCriteria = new SGACriteriaByMinCPUs((float)minCPU.longValue());
        }
        JsonNumber minMem = (JsonNumber)this.requirements.get(MEMORY_AMMOUNT_KEY);
        this.requirements.remove(MEMORY_AMMOUNT_KEY);
        if (minMem != null) {
            minMemCriteria = new SGACriteriaByMinFreeRAMMem((double)minMem.longValue());
        }
        availabilityCriteria = new SGACriteriaByAvailability();
        HashSet<String> aditionalRequirements = new HashSet<String>();
        for (String key : this.requirements.keySet()) {
            JsonValue value = (JsonValue)this.requirements.get(key);
            JsonValue.ValueType type = value.getValueType();
            switch (type) {
                case TRUE: {
                    aditionalRequirements.add(key);
                    break;
                }
            }
        }
        if (aditionalRequirements != null && !aditionalRequirements.isEmpty()) {
            aditionalCriteria = new SGACriteriaByRequirements(aditionalRequirements);
        }
        LinkedList<Object> criteriasToMeet = new LinkedList<Object>();
        if (platformsCriteria != null) {
            criteriasToMeet.add(platformsCriteria);
        }
        if (availabilityCriteria != null) {
            criteriasToMeet.add(availabilityCriteria);
        }
        if (minCPUsCriteria != null) {
            criteriasToMeet.add(minCPUsCriteria);
        }
        if (minMemCriteria != null) {
            criteriasToMeet.add(minMemCriteria);
        }
        if (aditionalCriteria != null) {
            criteriasToMeet.add(aditionalCriteria);
        }
        SGACriteriaAnd finalCriteria = new SGACriteriaAnd(criteriasToMeet);
        return new SGAFilter((SGACriteria)finalCriteria).filter(servers);
    }
}

