/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.job.v1;

import ibase.rest.model.job.v1.StatusChangeHistory;
import ibase.rest.model.job.v1.StatusType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Job {
    private String jobId = null;
    private String sessionId = null;
    private SubmitedByEnum submitedBy = null;
    private String projectId = null;
    private String algorithmId = null;
    private String algorithmVersion = null;
    private String jobOwner = null;
    private Boolean automaticallyMachineSelection = null;
    private String submissionMachine = null;
    private String submissionTime = null;
    private String executionMachine = null;
    private String endTime = null;
    private Integer numberOfAttempts = null;
    private String description = null;
    private Integer priority = null;
    private StatusType state = null;
    private Integer exitCode = null;
    private ExitStatusEnum exitStatus = null;
    private Double cpuTime = null;
    private Integer wallclockTime = null;
    private Double ramMemory = null;
    private String progressInfo = null;
    private List<StatusChangeHistory> statusHistory = new ArrayList<StatusChangeHistory>();
    private String lastModifiedTime = null;

    public Job jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @ApiModelProperty(value="The job Id.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public Job sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="The session Id used for job submission. By default, the sessionId is the project Id.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Job submitedBy(SubmitedByEnum submitedBy) {
        this.submitedBy = submitedBy;
        return this;
    }

    @ApiModelProperty(value="If the job was submit by the REST service or by RMI service.")
    public SubmitedByEnum getSubmitedBy() {
        return this.submitedBy;
    }

    public void setSubmitedBy(SubmitedByEnum submitedBy) {
        this.submitedBy = submitedBy;
    }

    public Job projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(value="The project Id associated with the job.")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Job algorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    @ApiModelProperty(value="The algorithm Id associated with the job.")
    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public Job algorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
        return this;
    }

    @ApiModelProperty(value="The algoritm version associated with the job.")
    public String getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public Job jobOwner(String jobOwner) {
        this.jobOwner = jobOwner;
        return this;
    }

    @ApiModelProperty(value="The user who submited the job.")
    public String getJobOwner() {
        return this.jobOwner;
    }

    public void setJobOwner(String jobOwner) {
        this.jobOwner = jobOwner;
    }

    public Job automaticallyMachineSelection(Boolean automaticallyMachineSelection) {
        this.automaticallyMachineSelection = automaticallyMachineSelection;
        return this;
    }

    @ApiModelProperty(value="If the user select a machine for execution or not.")
    public Boolean getAutomaticallyMachineSelection() {
        return this.automaticallyMachineSelection;
    }

    public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
        this.automaticallyMachineSelection = automaticallyMachineSelection;
    }

    public Job submissionMachine(String submissionMachine) {
        this.submissionMachine = submissionMachine;
        return this;
    }

    @ApiModelProperty(value="The machine selected for job execution. If the user choose the automatically machine selection, this information is empty.")
    public String getSubmissionMachine() {
        return this.submissionMachine;
    }

    public void setSubmissionMachine(String submissionMachine) {
        this.submissionMachine = submissionMachine;
    }

    public Job submissionTime(String submissionTime) {
        this.submissionTime = submissionTime;
        return this;
    }

    @ApiModelProperty(value="The submission time.")
    public String getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(String submissionTime) {
        this.submissionTime = submissionTime;
    }

    public Job executionMachine(String executionMachine) {
        this.executionMachine = executionMachine;
        return this;
    }

    @ApiModelProperty(value="The machine where the job executed (or was scheduled to execute).")
    public String getExecutionMachine() {
        return this.executionMachine;
    }

    public void setExecutionMachine(String executionMachine) {
        this.executionMachine = executionMachine;
    }

    public Job endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end time of the execution. It can be empty if the job have not already finished.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Job numberOfAttempts(Integer numberOfAttempts) {
        this.numberOfAttempts = numberOfAttempts;
        return this;
    }

    @ApiModelProperty(value="The number of times the job has already been scheduled for execution.")
    public Integer getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    public void setNumberOfAttempts(Integer numberOfAttempts) {
        this.numberOfAttempts = numberOfAttempts;
    }

    public Job description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description provided by the user at submission. It can be empty.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Job priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="The priority of the job.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Job state(StatusType state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="")
    public StatusType getState() {
        return this.state;
    }

    public void setState(StatusType state) {
        this.state = state;
    }

    public Job exitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @ApiModelProperty(value="The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.")
    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public Job exitStatus(ExitStatusEnum exitStatus) {
        this.exitStatus = exitStatus;
        return this;
    }

    @ApiModelProperty(value="The status describing the end of the execution. It can be empty if the job have not already finished.")
    public ExitStatusEnum getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(ExitStatusEnum exitStatus) {
        this.exitStatus = exitStatus;
    }

    public Job cpuTime(Double cpuTime) {
        this.cpuTime = cpuTime;
        return this;
    }

    @ApiModelProperty(value="")
    public Double getCpuTime() {
        return this.cpuTime;
    }

    public void setCpuTime(Double cpuTime) {
        this.cpuTime = cpuTime;
    }

    public Job wallclockTime(Integer wallclockTime) {
        this.wallclockTime = wallclockTime;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getWallclockTime() {
        return this.wallclockTime;
    }

    public void setWallclockTime(Integer wallclockTime) {
        this.wallclockTime = wallclockTime;
    }

    public Job ramMemory(Double ramMemory) {
        this.ramMemory = ramMemory;
        return this;
    }

    @ApiModelProperty(value="")
    public Double getRamMemory() {
        return this.ramMemory;
    }

    public void setRamMemory(Double ramMemory) {
        this.ramMemory = ramMemory;
    }

    public Job progressInfo(String progressInfo) {
        this.progressInfo = progressInfo;
        return this;
    }

    @ApiModelProperty(value="The progress info about a job.")
    public String getProgressInfo() {
        return this.progressInfo;
    }

    public void setProgressInfo(String progressInfo) {
        this.progressInfo = progressInfo;
    }

    public Job statusHistory(List<StatusChangeHistory> statusHistory) {
        this.statusHistory = statusHistory;
        return this;
    }

    public Job addStatusHistoryItem(StatusChangeHistory statusHistoryItem) {
        this.statusHistory.add(statusHistoryItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<StatusChangeHistory> getStatusHistory() {
        return this.statusHistory;
    }

    public void setStatusHistory(List<StatusChangeHistory> statusHistory) {
        this.statusHistory = statusHistory;
    }

    public Job lastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    @ApiModelProperty(value="The time of job last modification.")
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return Objects.equals(this.jobId, job.jobId) && Objects.equals(this.sessionId, job.sessionId) && Objects.equals((Object)this.submitedBy, (Object)job.submitedBy) && Objects.equals(this.projectId, job.projectId) && Objects.equals(this.algorithmId, job.algorithmId) && Objects.equals(this.algorithmVersion, job.algorithmVersion) && Objects.equals(this.jobOwner, job.jobOwner) && Objects.equals(this.automaticallyMachineSelection, job.automaticallyMachineSelection) && Objects.equals(this.submissionMachine, job.submissionMachine) && Objects.equals(this.submissionTime, job.submissionTime) && Objects.equals(this.executionMachine, job.executionMachine) && Objects.equals(this.endTime, job.endTime) && Objects.equals(this.numberOfAttempts, job.numberOfAttempts) && Objects.equals(this.description, job.description) && Objects.equals(this.priority, job.priority) && Objects.equals((Object)this.state, (Object)job.state) && Objects.equals(this.exitCode, job.exitCode) && Objects.equals((Object)this.exitStatus, (Object)job.exitStatus) && Objects.equals(this.cpuTime, job.cpuTime) && Objects.equals(this.wallclockTime, job.wallclockTime) && Objects.equals(this.ramMemory, job.ramMemory) && Objects.equals(this.progressInfo, job.progressInfo) && Objects.equals(this.statusHistory, job.statusHistory) && Objects.equals(this.lastModifiedTime, job.lastModifiedTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.sessionId, this.submitedBy, this.projectId, this.algorithmId, this.algorithmVersion, this.jobOwner, this.automaticallyMachineSelection, this.submissionMachine, this.submissionTime, this.executionMachine, this.endTime, this.numberOfAttempts, this.description, this.priority, this.state, this.exitCode, this.exitStatus, this.cpuTime, this.wallclockTime, this.ramMemory, this.progressInfo, this.statusHistory, this.lastModifiedTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Job {\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    submitedBy: ").append(this.toIndentedString((Object)this.submitedBy)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    algorithmId: ").append(this.toIndentedString(this.algorithmId)).append("\n");
        sb.append("    algorithmVersion: ").append(this.toIndentedString(this.algorithmVersion)).append("\n");
        sb.append("    jobOwner: ").append(this.toIndentedString(this.jobOwner)).append("\n");
        sb.append("    automaticallyMachineSelection: ").append(this.toIndentedString(this.automaticallyMachineSelection)).append("\n");
        sb.append("    submissionMachine: ").append(this.toIndentedString(this.submissionMachine)).append("\n");
        sb.append("    submissionTime: ").append(this.toIndentedString(this.submissionTime)).append("\n");
        sb.append("    executionMachine: ").append(this.toIndentedString(this.executionMachine)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    numberOfAttempts: ").append(this.toIndentedString(this.numberOfAttempts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("    exitStatus: ").append(this.toIndentedString((Object)this.exitStatus)).append("\n");
        sb.append("    cpuTime: ").append(this.toIndentedString(this.cpuTime)).append("\n");
        sb.append("    wallclockTime: ").append(this.toIndentedString(this.wallclockTime)).append("\n");
        sb.append("    ramMemory: ").append(this.toIndentedString(this.ramMemory)).append("\n");
        sb.append("    progressInfo: ").append(this.toIndentedString(this.progressInfo)).append("\n");
        sb.append("    statusHistory: ").append(this.toIndentedString(this.statusHistory)).append("\n");
        sb.append("    lastModifiedTime: ").append(this.toIndentedString(this.lastModifiedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExitStatusEnum {
        UNKNOWN("unknown"),
        SUCCESS("success"),
        EXECUTION_ERROR("execution_error"),
        JOB_IDENTIFIER_NOT_FOUND("job_identifier_not_found"),
        UNEXPECTED_MACHINE_ERROR("unexpected_machine_error"),
        PROJECT_NOT_FOUND("project_not_found"),
        FAILED_SETUP_EXECUTION_ENVIRONMENT("failed_setup_execution_environment"),
        NO_PERMISSION("no_permission"),
        NO_MACHINE_AVAILABLE("no_machine_available"),
        KILLED("killed"),
        LOST("lost"),
        UNDEFINED("undefined");

        private String value;

        private ExitStatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum SubmitedByEnum {
        REST_SERVICE("REST Service"),
        RMI_SERVICE("RMI Service");

        private String value;

        private SubmitedByEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

