/*
 * Decompiled with CFR 0.152.
 */
package ibase.dao.api.job.v1;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import ibase.rest.api.job.v1.adapter.JobDAO;
import ibase.rest.model.job.v1.Job;
import ibase.rest.model.job.v1.JobSession;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoJobDAO
implements JobDAO {
    private MongoDatabase db;
    private ObjectMapper mapper;
    private static final String JOBS_COLLECTION = "jobs";
    private static final String JOB_ID = "jobId";

    public MongoJobDAO(MongoDatabase mongoDatabase) {
        this.db = mongoDatabase;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public boolean containsJob(String jobId) {
        MongoCollection jobs = this.db.getCollection(JOBS_COLLECTION);
        return jobs.find(Filters.eq((String)JOB_ID, (Object)jobId)).first() != null;
    }

    public List<Job> findAllJobs() {
        MongoCollection jobs = this.db.getCollection(JOBS_COLLECTION);
        FindIterable documents = jobs.find();
        return this.toJobList((FindIterable<Document>)documents);
    }

    public Job findJobById(String jobId) {
        MongoCollection jobs = this.db.getCollection(JOBS_COLLECTION);
        Document document = (Document)jobs.find(Filters.eq((String)JOB_ID, (Object)jobId)).first();
        return this.toJob(document);
    }

    public List<Job> findJobsBySession(String jobSessionId) {
        MongoCollection jobs = this.db.getCollection(JOBS_COLLECTION);
        Document query = new Document("sessionId", (Object)jobSessionId);
        FindIterable documents = jobs.find((Bson)query);
        return this.toJobList((FindIterable<Document>)documents);
    }

    public List<Job> findJobs(String projectId, Long modifiedAfter) {
        MongoCollection jobs = this.db.getCollection(JOBS_COLLECTION);
        Document query = null;
        if (projectId != null) {
            query = new Document("projectId", (Object)projectId);
        }
        if (modifiedAfter != null) {
            String timestamp = LocalDateTime.ofInstant(Instant.ofEpochSecond(modifiedAfter), TimeZone.getDefault().toZoneId()).toString();
            if (query != null) {
                query.append("lastModifiedTime", (Object)new Document("$gte", (Object)timestamp));
            } else {
                query = new Document("lastModifiedTime", (Object)new Document("$gte", (Object)timestamp));
            }
        }
        FindIterable documents = query == null ? jobs.find() : jobs.find((Bson)query);
        return this.toJobList((FindIterable<Document>)documents);
    }

    public boolean insertJob(Job job) {
        MongoCollection jobs = this.db.getCollection(JOBS_COLLECTION);
        try {
            String userJson = this.mapper.writeValueAsString((Object)job);
            Document doc = Document.parse((String)userJson);
            jobs.insertOne((Object)doc);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updateJob(Job job) {
        MongoCollection jobs = this.db.getCollection(JOBS_COLLECTION);
        try {
            String jobJson = this.mapper.writeValueAsString((Object)job);
            Document jobDoc = Document.parse((String)jobJson);
            jobs.findOneAndUpdate(Filters.eq((String)JOB_ID, (Object)job.getJobId()), (Bson)new Document("$set", (Object)jobDoc));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Job toJob(Document document) {
        if (document == null) {
            return null;
        }
        String json = document.toJson();
        try {
            return (Job)this.mapper.readValue(json, Job.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    private List<Job> toJobList(FindIterable<Document> documents) {
        if (documents == null) {
            return null;
        }
        ArrayList<Job> jobsToReturn = new ArrayList<Job>();
        for (Document document : documents) {
            String json = document.toJson();
            try {
                jobsToReturn.add((Job)this.mapper.readValue(json, Job.class));
            }
            catch (IOException e) {
                return null;
            }
        }
        return jobsToReturn;
    }

    public boolean containsJobSession(String sessionId) {
        return false;
    }

    public List<JobSession> findAllJobSessions() {
        return null;
    }

    public JobSession findJobSessionById(String sessionId) {
        return null;
    }

    public void insertJobSession(JobSession jobSession) {
    }
}

