/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.project.v2.impl;

import ibase.common.v2.ServiceAdapter;
import ibase.common.v2.ServiceUtil;
import ibase.exception.v2.InvalidParameterException;
import ibase.exception.v2.PermissionException;
import ibase.rest.api.authentication.v2.adapter.AuthenticationService;
import ibase.rest.api.authentication.v2.adapter.ParseException;
import ibase.rest.api.project.v2.NotFoundException;
import ibase.rest.api.project.v2.ProjectsApiService;
import ibase.rest.api.project.v2.adapter.AccessType;
import ibase.rest.api.project.v2.adapter.Project;
import ibase.rest.api.project.v2.adapter.ProjectFile;
import ibase.rest.api.project.v2.adapter.ProjectInfo;
import ibase.rest.api.project.v2.adapter.ProjectService;
import ibase.rest.api.project.v2.adapter.SharingType;
import ibase.rest.api.project.v2.impl.CharsetDetector;
import ibase.rest.api.user.v2.adapter.UserService;
import ibase.rest.model.project.v2.FileMetadata;
import ibase.rest.model.project.v2.Project;
import ibase.rest.model.project.v2.SuccessfulGetFileIdLink;
import ibase.rest.model.project.v2.SuccessfulGetFilesLink;
import ibase.rest.model.project.v2.SuccessfulUploadFile;
import ibase.rest.model.project.v2.TeamMember;
import ibase.rest.model.project.v2.User;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import tecgraf.javautils.core.timestamp.TStamp64;

public class ProjectsApiServiceImpl
extends ProjectsApiService {
    private static final String ALL_PROJECTS = "ALL";
    private static final String MY_PROJECTS = "MY";
    private static final String UPLOAD_MULTIPART = "multipart";
    private static final String UPLOAD_RESUMABLE = "resumable";
    public static final String RESOURCE_BUNDLE = "language.v2.ProjectsApi";
    private static final String ROOT = "root";
    public static final String GUEST_ROLE = "guest";
    public static final String GUEST_TAG_PROJECT_VISIBILITY = "#guest";
    public static final String ATTRIBUTE_PROJECT_ID = "projectId";
    public static final String ATTRIBUTE_TEMP_FILE_NAME = "tempFileName";
    public static final String ATTRIBUTE_ORIGINAL_FILE_NAME = "originalFileName";
    private static final String SHARED_PROJECTS = "SHARED";
    private static final MediaType TEXT_MEDIA_TYPE = new MediaType("text", "*");
    private static final Logger logger = Logger.getLogger("ProjectsApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    protected User buildRestUser(String userId, String localeString) {
        Client client = ServiceUtil.getClient();
        WebTarget target = client.target(ServiceAdapter.getURI());
        Response response = target.path("users").path(userId).queryParam("locale", new Object[]{localeString}).request(new String[]{"application/json;charset=UTF-8"}).header("Authorization", (Object)ServiceAdapter.getAutheticationHeader()).get();
        if (response.getStatus() != 200) {
            return null;
        }
        User restUser = (User)response.readEntity(User.class);
        return restUser;
    }

    private TeamMember makeTeamMember(User restUser, boolean editable) {
        TeamMember member = new TeamMember();
        member.setId(restUser.getId());
        member.setLogin(restUser.getLogin());
        member.setName(restUser.getName());
        member.setEditable(editable);
        member.setAvatar(restUser.getAvatar());
        return member;
    }

    protected User makeRestUser(String userId, String localeString, Map<String, User> userIdToUserCache) {
        User restUser = userIdToUserCache.get(userId);
        if (restUser == null && (restUser = this.buildRestUser(userId, localeString)) != null) {
            userIdToUserCache.put(userId, restUser);
        }
        return restUser;
    }

    protected TeamMember buildRestTeamMemberWithCache(String userId, boolean editable, String localeString, Map<String, User> userIdToUserCache) {
        User restUser = this.makeRestUser(userId, localeString, userIdToUserCache);
        if (restUser == null) {
            return null;
        }
        return this.makeTeamMember(restUser, editable);
    }

    protected TeamMember buildRestTeamMember(String userId, boolean editable, String localeString) {
        User restUser = this.buildRestUser(userId, localeString);
        if (restUser == null) {
            return null;
        }
        return this.makeTeamMember(restUser, editable);
    }

    private ibase.rest.model.project.v2.Project buildRestProject(Project project, String localeString) {
        return this.buildRestProject(project, localeString, false, null);
    }

    protected ibase.rest.model.project.v2.Project buildRestProject(Project project, String localeString, boolean canCache, Map<String, User> userIdToUserCache) {
        ibase.rest.model.project.v2.Project restProject = new ibase.rest.model.project.v2.Project();
        User owner = canCache ? this.makeRestUser(project.getOwnerId(), localeString, userIdToUserCache) : this.buildRestUser(project.getOwnerId(), localeString);
        if (owner == null) {
            return null;
        }
        restProject.setOwner(owner);
        restProject.isOwner(project.getOwnerId().equals(ServiceAdapter.getCurrentUser()));
        restProject.setId(ServiceUtil.encodeToBase64((String)project.getId()));
        restProject.setDescription(project.getDescription());
        restProject.setName(project.getName());
        restProject.setModified(project.getLastModificationDate());
        restProject.setCreated(project.getCreationDate());
        restProject.setType(project.getType());
        restProject.setVisibility(Project.VisibilityEnum.valueOf(project.getSharingType().name()));
        ArrayList<TeamMember> projectMembers = new ArrayList<TeamMember>();
        project.getTeamMembers(AccessType.READ_ONLY).forEach(u -> {
            TeamMember m = canCache ? this.buildRestTeamMemberWithCache((String)u, false, localeString, userIdToUserCache) : this.buildRestTeamMember((String)u, false, localeString);
            if (m != null) {
                projectMembers.add(m);
            }
        });
        project.getTeamMembers(AccessType.READ_WRITE).forEach(u -> {
            TeamMember m = canCache ? this.buildRestTeamMemberWithCache((String)u, true, localeString, userIdToUserCache) : this.buildRestTeamMember((String)u, true, localeString);
            if (m != null) {
                projectMembers.add(m);
            }
        });
        restProject.setMembers(projectMembers);
        String userId = ServiceAdapter.getCurrentUser();
        restProject.setEditable(project.isWritableByUser(userId));
        return restProject;
    }

    private ibase.rest.model.project.v2.ProjectFile buildRestProjectFile(ProjectFile file, boolean showHiddenFiles) {
        ibase.rest.model.project.v2.ProjectFile projectFile = new ibase.rest.model.project.v2.ProjectFile();
        String ownerId = file.whoCreated();
        if (ownerId != null) {
            projectFile.setCreatedBy(ownerId);
        }
        projectFile.setCreated(file.getCreationDate());
        projectFile.setDescription(file.getDescription());
        projectFile.setIsFolder(file.isDirectory());
        projectFile.setName(file.getName());
        projectFile.setIsUnderConstruction(file.isUnderConstruction());
        projectFile.setIsLocked(file.isLocked());
        projectFile.setModified(file.getModificationDate());
        projectFile.setPath(file.getId());
        projectFile.setBytes(file.size());
        projectFile.setNumberOfChildren(file.isDirectory() != false ? file.getNumberOfChildren(showHiddenFiles) : 0);
        projectFile.setId(this.getFileId(file));
        String parentId = file.getParentId();
        if (parentId != null) {
            projectFile.setParentId(this.getFileId(parentId));
        }
        if (!file.isDirectory().booleanValue()) {
            String mimeType = URLConnection.guessContentTypeFromName(file.getName());
            if (mimeType == null) {
                mimeType = file.getMimeType();
            }
            projectFile.setMimeType(mimeType != null ? mimeType : "content/unknown");
        }
        return projectFile;
    }

    private String getFileId(ProjectFile file) {
        return this.getFileId(file.getId());
    }

    private String getFileId(String id) {
        String fileId = ServiceUtil.encodeToBase64((String)id);
        return "".equals(fileId) ? ROOT : fileId;
    }

    private String getFilePath(String fileId) {
        return ROOT.equalsIgnoreCase(fileId) ? "" : ServiceUtil.decodeFromBase64((String)fileId);
    }

    private FileMetadata getFileMetadata(ProjectFile file, boolean showHiddenFiles, String localeString) throws RemoteException, PermissionException {
        FileMetadata fileMetadata = new FileMetadata();
        ArrayList<ibase.rest.model.project.v2.ProjectFile> content = new ArrayList<ibase.rest.model.project.v2.ProjectFile>();
        HashMap userIdToUserCache = new HashMap();
        boolean canCache = false;
        if (file.isDirectory().booleanValue()) {
            boolean _canCache = canCache = true;
            Stream.of(file.getChildren(showHiddenFiles)).forEach(i -> content.add(this.buildRestProjectFile((ProjectFile)i, showHiddenFiles)));
        }
        fileMetadata.setFile(this.buildRestProjectFile(file, showHiddenFiles));
        fileMetadata.setContent(content);
        return fileMetadata;
    }

    private byte[] toArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] byteArray = buffer.toByteArray();
        return byteArray;
    }

    @Override
    public Response projectsGet(String name, String subset, Boolean onlyEditable, String locale, SecurityContext securityContext) {
        try {
            subset = subset == null || subset.isEmpty() ? ALL_PROJECTS : subset.toUpperCase();
            boolean onlyWritable = onlyEditable == null ? false : onlyEditable;
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.list.info", new String[]{subset, name}));
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            UserService userService = (UserService)ServiceAdapter.getInstance(UserService.class, (String)locale);
            if (!(subset.equalsIgnoreCase(ALL_PROJECTS) || subset.equalsIgnoreCase(MY_PROJECTS) || subset.equalsIgnoreCase(SHARED_PROJECTS))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.get.invalid.subset", new String[0]));
            }
            ArrayList<ProjectInfo> projects = new ArrayList<ProjectInfo>();
            String userId = ServiceAdapter.getCurrentUser();
            ibase.rest.api.user.v2.adapter.User userFromService = userService.getUser(userId);
            if (userFromService == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[0]));
            }
            switch (subset) {
                case "ALL": {
                    if (userFromService.isAdmin()) {
                        projects.addAll(projectService.getAllProjects(userId));
                        break;
                    }
                    projects.addAll(projectService.getProjectsCreatedBy(userId));
                    projects.addAll(projectService.getProjectsSharedWith(userId));
                    break;
                }
                case "MY": {
                    projects.addAll(projectService.getProjectsCreatedBy(userId));
                    break;
                }
                case "SHARED": {
                    projects.addAll(projectService.getProjectsSharedWith(userId));
                }
            }
            User currentUser = this.buildRestUser(ServiceAdapter.getCurrentUser(), locale);
            boolean isGuest = currentUser.getRoles().contains(GUEST_ROLE);
            ArrayList<ibase.rest.model.project.v2.Project> projectList = new ArrayList<ibase.rest.model.project.v2.Project>();
            HashMap<String, User> userIdToUserCache = new HashMap<String, User>();
            boolean canCache = true;
            for (ProjectInfo pi : projects) {
                if (isGuest && !pi.getDescription().contains(GUEST_TAG_PROJECT_VISIBILITY) || name != null && !pi.getName().toLowerCase().contains(name.toLowerCase()) || onlyWritable && !pi.isWritableByUser(userId).booleanValue()) continue;
                ibase.rest.model.project.v2.Project restProject = this.buildRestProject(projectService.getProject(pi.getId()), locale, true, userIdToUserCache);
                if (restProject != null) {
                    projectList.add(restProject);
                    continue;
                }
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.creation.user.not.found.error", new String[0]));
            }
            return Response.ok().entity(projectList).build();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsPermissionsGet(String locale, SecurityContext securityContext) {
        try {
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.permissions", new String[0]));
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            ArrayList<ProjectInfo> projects = new ArrayList<ProjectInfo>();
            String userId = ServiceAdapter.getCurrentUser();
            UserService userService = (UserService)ServiceAdapter.getInstance(UserService.class, (String)locale);
            ibase.rest.api.user.v2.adapter.User userFromService = userService.getUser(userId);
            if (userFromService == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[0]));
            }
            if (userFromService.isAdmin()) {
                projects.addAll(projectService.getAllProjects(userId));
            } else {
                projects.addAll(projectService.getProjectsCreatedBy(userId));
                projects.addAll(projectService.getProjectsSharedWith(userId));
            }
            List projectIdList = projects.stream().map(ProjectInfo::getId).collect(Collectors.toList());
            return Response.ok().entity(projectIdList).build();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsPost(String name, String description, String type, String visibility, String locale, SecurityContext securityContext) {
        if (name == null || name.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.post.missing.name", new String[0]));
        }
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.creation.info", new String[]{name, visibility}));
            visibility = visibility == null ? SharingType.PRIVATE.name() : visibility.toUpperCase();
            try {
                SharingType.valueOf(visibility);
            }
            catch (IllegalArgumentException e) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.creation.invalid.visibility", new String[0]));
            }
            String userId = ServiceAdapter.getCurrentUser();
            Project newProject = projectService.createProject(name, userId, description, type, SharingType.valueOf(visibility));
            ibase.rest.model.project.v2.Project restProject = this.buildRestProject(newProject, locale);
            if (restProject != null) {
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)restProject).build();
            }
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.creation.user.not.found.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdGet(String projectId, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.findById.info", new String[]{projectId}));
            try {
                projectId = ServiceUtil.decodeFromBase64((String)projectId);
            }
            catch (Exception e) {
                projectId = "";
            }
            if (projectId.trim().isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.id.invalid.error", new String[0]));
            }
            Project project = projectService.getProject(projectId);
            if (project != null) {
                return Response.ok().entity((Object)this.buildRestProject(project, locale)).build();
            }
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public Response projectsProjectIdPut(String projectId, String locale, String description, String type, String visibility, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.update.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            if (description == null && visibility == null && type == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.update.invalid.parameters", new String[0]));
            }
            SharingType sharingType = null;
            if (visibility != null) {
                try {
                    sharingType = SharingType.valueOf(visibility.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.update.invalid.visibility", new String[0]));
                }
            }
            try {
                projectService.getProject(projectId);
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            Project project = projectService.updateProject(projectId, description, type, sharingType);
            return Response.ok().entity((Object)this.buildRestProject(project, locale)).build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdDelete(String projectId, String locale, SecurityContext securityContext) {
        try {
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.delete.info", new String[]{projectId}));
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            try {
                projectService.getProject(projectId);
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            projectService.removeProject(projectId);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdMembersGet(String projectId, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.get.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            Project project = projectService.getProject(projectId);
            ArrayList projectMembers = new ArrayList();
            project.getTeamMembers(AccessType.READ_ONLY).forEach(u -> {
                TeamMember m = this.buildRestTeamMember((String)u, true, locale);
                if (m != null) {
                    projectMembers.add(m);
                }
            });
            project.getTeamMembers(AccessType.READ_WRITE).forEach(u -> {
                TeamMember m = this.buildRestTeamMember((String)u, false, locale);
                if (m != null) {
                    projectMembers.add(m);
                }
            });
            return Response.ok().entity(projectMembers).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public synchronized Response projectsProjectIdMembersUserIdDelete(String projectId, String userId, String locale, SecurityContext securityContext) {
        try {
            Project project;
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.delete.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            if (userId == null || this.buildRestUser(userId, locale) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[]{userId}));
            }
            try {
                project = projectService.getProject(projectId);
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            if (!project.getSharingType().equals((Object)SharingType.SELECTIVE)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.update.invalid.error", new String[0]));
            }
            if (!project.removeTeamMember(userId)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.member.delete.error", new String[]{userId}));
            }
            return Response.noContent().build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public synchronized Response projectsProjectIdMembersUserIdPut(String projectId, String userId, Boolean editable, String locale, SecurityContext securityContext) {
        try {
            Project project;
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.update.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            if (userId == null || this.buildRestUser(userId, locale) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[]{userId}));
            }
            try {
                project = projectService.getProject(projectId);
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            if (!project.getSharingType().equals((Object)SharingType.SELECTIVE)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.update.invalid.error", new String[0]));
            }
            if (project.getOwnerId().equals(userId)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.owner.cannot.be.member.error", new String[0]));
            }
            if (editable == null) {
                editable = false;
            }
            if (!editable.booleanValue()) {
                project.addTeamMember(AccessType.READ_ONLY, userId);
            } else {
                project.addTeamMember(AccessType.READ_WRITE, userId);
            }
            TeamMember member = this.buildRestTeamMember(userId, editable, locale);
            if (member != null) {
                return Response.ok().entity((Object)member).build();
            }
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[]{userId}));
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdMembersUserIdGet(String projectId, String userId, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.user.get.info", new String[]{projectId}));
            if (userId == null || this.buildRestUser(userId, locale) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[]{userId}));
            }
            Project project = projectService.getProject(projectId);
            AccessType accessType = project.getUserAccessType(userId);
            if (accessType == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.member.not.found.error", new String[]{userId}));
            }
            switch (accessType) {
                case READ_ONLY: {
                    TeamMember member = this.buildRestTeamMember(userId, false, locale);
                    if (member == null) break;
                    return Response.ok().entity((Object)member).build();
                }
                case READ_WRITE: {
                    TeamMember member = this.buildRestTeamMember(userId, true, locale);
                    if (member == null) break;
                    return Response.ok().entity((Object)member).build();
                }
            }
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.member.not.found.error", new String[]{userId}));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdGet(String projectId, String fileId, Boolean compress, String charset, String locale, SecurityContext securityContext) {
        try {
            MediaType responseMediaType;
            if (!ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)fileId))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.invalid.file.path", new String[0]));
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            String originalProjectId = ServiceUtil.decodeFromBase64((String)projectId);
            fileId = this.getFilePath(fileId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.download.info", new String[]{originalProjectId, fileId}));
            ProjectFile file = projectService.getProjectFile(originalProjectId, fileId);
            if (file.isDirectory().booleanValue() || compress != null && compress.booleanValue()) {
                ArrayList<String> files = new ArrayList<String>();
                files.add(ServiceUtil.encodeToBase64((String)file.getId()));
                return this.projectsProjectIdFilesGet(files, projectId, file.getName(), locale, securityContext);
            }
            FileMetadata fileMetadata = this.getFileMetadata(file, true, locale);
            final InputStream is = file.getInputStream();
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                    out.flush();
                    is.close();
                }
            };
            MediaType mtFromMime = MediaType.valueOf((String)fileMetadata.getFile().getMimeType());
            if (mtFromMime.isCompatible(TEXT_MEDIA_TYPE)) {
                if (charset != null && !charset.isEmpty()) {
                    if (!(charset.equalsIgnoreCase("UTF-8") || charset.equalsIgnoreCase("ISO-8859-1") || charset.equalsIgnoreCase("US-ASCII"))) {
                        return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.get.invalid.charset", new String[0]));
                    }
                    charset = charset.toUpperCase();
                } else {
                    Charset cs = CharsetDetector.detectCharset(file);
                    charset = cs != null ? cs.name() : null;
                }
                responseMediaType = mtFromMime.withCharset(charset);
            } else {
                responseMediaType = mtFromMime;
            }
            return Response.ok((Object)output).type(responseMediaType).header("Content-Disposition", (Object)("filename=\"" + fileMetadata.getFile().getName() + "\"")).encoding(charset).build();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesParentIdPost(String sourceProjectId, String folderId, InputStream inputStream, FormDataContentDisposition fileDetail, String uploadType, String uploadId, Long rangeStart, Long rangeEnd, Long totalSize, String locale, String charset, SecurityContext securityContext) {
        Response response;
        ProjectFile file = null;
        try {
            Response response2;
            ProjectFile folder;
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            String projectId = ServiceUtil.decodeFromBase64((String)sourceProjectId);
            folderId = this.getFilePath(folderId);
            String fileName = fileDetail.getFileName();
            if (fileName == null || fileName.isEmpty()) {
                Response response3 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.filename.missing.error", new String[0]));
                return response3;
            }
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.info", new String[]{projectId, folderId}));
            if (uploadType == null) {
                Response response4 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.type.missing.error", new String[0]));
                return response4;
            }
            boolean uploadMultipart = false;
            if (UPLOAD_MULTIPART.equalsIgnoreCase(uploadType)) {
                uploadMultipart = true;
            } else if (!UPLOAD_RESUMABLE.equalsIgnoreCase(uploadType)) {
                Response e = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.type.missing.error", new String[0]));
                return e;
            }
            try {
                folder = projectService.getProjectFile(projectId, folderId);
            }
            catch (PermissionException e) {
                Response response5 = ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
                if (file != null) {
                    try {
                        file.close(true);
                    }
                    catch (IOException e2) {
                        throw new InternalServerErrorException((Throwable)e2);
                    }
                }
                return response5;
            }
            if (folder == null) {
                Response e = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.folder.invalid.error", new String[0]));
                return e;
            }
            if (uploadMultipart) {
                if (folder.containsChild(fileName)) {
                    file = folder.getChild(fileName);
                    if (file.isDirectory().booleanValue()) {
                        Response e = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.name.usedby.folder", new String[]{fileName}));
                        return e;
                    }
                } else {
                    file = folder.createFile(fileName, ServiceUtil.getLocale((String)locale));
                }
                if (charset != null && !charset.isEmpty()) {
                    OutputStreamWriter outputStreamWriter;
                    String readCharset = "UTF-8";
                    try {
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName(readCharset));
                        outputStreamWriter = new OutputStreamWriter(file.getOutputStream(), charset.toUpperCase());
                        char[] cbuffer = new char[1024];
                        int ncRead = 0;
                        while ((ncRead = inputStreamReader.read(cbuffer)) != -1) {
                            outputStreamWriter.write(cbuffer, 0, ncRead);
                        }
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                        inputStreamReader.close();
                    }
                    catch (IOException e) {
                        throw new InternalServerErrorException((Throwable)e);
                    }
                    SuccessfulUploadFile inlineResponse = new SuccessfulUploadFile();
                    inlineResponse.setFileId(this.getFileId(file));
                    file.close(false);
                    outputStreamWriter = Response.ok().entity((Object)inlineResponse).build();
                    return outputStreamWriter;
                }
                try {
                    OutputStream out = file.getOutputStream();
                    int read = 0;
                    byte[] bytes = new byte[1024];
                    while ((read = inputStream.read(bytes)) != -1) {
                        out.write(bytes, 0, read);
                    }
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new InternalServerErrorException((Throwable)e);
                }
                SuccessfulUploadFile inlineResponse = new SuccessfulUploadFile();
                inlineResponse.setFileId(this.getFileId(file));
                file.close(false);
                Response read = Response.ok().entity((Object)inlineResponse).build();
                return read;
            }
            if (rangeStart == null || rangeEnd == null || totalSize == null || rangeStart < 0L || rangeEnd < 0L || totalSize < 0L) {
                Response inlineResponse = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.invalid.parameters", new String[0]));
                return inlineResponse;
            }
            String tempFileName = null;
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            if (uploadId == null) {
                tempFileName = ".rest_" + new TStamp64().toString();
                Calendar c = Calendar.getInstance();
                c.add(1, 10);
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put(ATTRIBUTE_ORIGINAL_FILE_NAME, fileDetail.getFileName());
                attributes.put(ATTRIBUTE_PROJECT_ID, sourceProjectId);
                attributes.put(ATTRIBUTE_TEMP_FILE_NAME, folderId + "/" + tempFileName);
                uploadId = authenticationService.createToken(ServiceAdapter.getCurrentUser(), attributes, c.getTime());
                file = folder.createFile(tempFileName, ServiceUtil.getLocale((String)locale));
            } else {
                HashMap attributes = new HashMap();
                try {
                    authenticationService.parserToken(uploadId, attributes);
                }
                catch (ParseException e) {
                    Response ncRead = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.invalid.token.error", new String[0]));
                    if (file != null) {
                        try {
                            file.close(true);
                        }
                        catch (IOException e3) {
                            throw new InternalServerErrorException((Throwable)e3);
                        }
                    }
                    return ncRead;
                }
                tempFileName = (String)attributes.get(ATTRIBUTE_TEMP_FILE_NAME);
                String tokenRealFileName = (String)attributes.get(ATTRIBUTE_ORIGINAL_FILE_NAME);
                String receivedProjectId = (String)attributes.get(ATTRIBUTE_PROJECT_ID);
                if (tempFileName == null || receivedProjectId == null || tokenRealFileName == null) {
                    Response e3 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.invalid.token.error", new String[0]));
                    return e3;
                }
                if (!tokenRealFileName.equals(fileDetail.getFileName()) || !receivedProjectId.equals(sourceProjectId)) {
                    Response e3 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.invalid.token.error", new String[0]));
                    return e3;
                }
                file = projectService.getProjectFile(ServiceUtil.decodeFromBase64((String)receivedProjectId), tempFileName);
            }
            file.open(false);
            int chunck_size = (int)(rangeEnd - rangeStart);
            file.write(this.toArray(inputStream), 0, chunck_size, rangeStart);
            if (file.size() + (long)chunck_size == totalSize) {
                if (folder.containsChild(fileName)) {
                    ProjectFile toRemoveFile = folder.getChild(fileName);
                    if (toRemoveFile.isDirectory().booleanValue()) {
                        response2 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.name.usedby.folder", new String[]{fileName}));
                        return response2;
                    }
                    toRemoveFile.remove();
                }
                file.close(false);
                file.rename(fileDetail.getFileName());
                file.changeTypeByExtension();
                file = projectService.getProjectFile(ServiceUtil.decodeFromBase64((String)sourceProjectId), folder.getId() + "/" + fileDetail.getFileName());
                file.close(false);
            } else {
                file.close(false);
            }
            SuccessfulUploadFile inlineResponse = new SuccessfulUploadFile();
            inlineResponse.setUploadId(uploadId);
            inlineResponse.setFileId(this.getFileId(file));
            response2 = Response.ok().entity((Object)inlineResponse).build();
            return response2;
        }
        catch (PermissionException p) {
            response = ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
            return response;
        }
        catch (ibase.common.v2.NotFoundException e) {
            response = ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            return response;
        }
        catch (InvalidParameterException e) {
            response = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
            return response;
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
        finally {
            if (file != null) {
                try {
                    file.close(true);
                }
                catch (IOException e) {
                    throw new InternalServerErrorException((Throwable)e);
                }
            }
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdDelete(String projectId, String fileId, String locale, SecurityContext securityContext) {
        try {
            ProjectFile file;
            if (!ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)fileId))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.invalid.file.path", new String[0]));
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            fileId = ServiceUtil.decodeFromBase64((String)fileId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.files.delete.info", new String[]{projectId}));
            try {
                file = projectService.getProjectFile(projectId, fileId);
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            file.remove();
            return Response.noContent().build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdLinkGet(String projectId, String fileId, Boolean compress, String locale, SecurityContext securityContext) {
        try {
            if (!ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)fileId))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.invalid.file.path", new String[0]));
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            ProjectFile file = projectService.getProjectFile(ServiceUtil.decodeFromBase64((String)projectId), this.getFilePath(fileId));
            FileMetadata fileMetadata = this.getFileMetadata(file, true, locale);
            StringBuilder builder = new StringBuilder();
            builder.append(ServiceAdapter.getURI());
            builder.append("/links/download/");
            String userId = ServiceAdapter.getCurrentUser();
            builder.append(authenticationService.createToken(userId, null, new Date(System.currentTimeMillis() + 30000L)));
            builder.append("/");
            builder.append(projectId);
            builder.append("/");
            builder.append(fileId);
            if (compress != null && compress.booleanValue()) {
                builder.append("?compress=true");
            }
            SuccessfulGetFileIdLink response = new SuccessfulGetFileIdLink();
            response.setUrl(builder.toString());
            response.setFileName(fileMetadata.getFile().getName());
            response.setMimeType(fileMetadata.getFile().getMimeType());
            return Response.ok().entity((Object)response).build();
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdMetadataGet(String projectId, String fileId, Boolean showHiddenFiles, String locale, SecurityContext securityContext) {
        try {
            if (!ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)fileId))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.invalid.file.path", new String[0]));
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            showHiddenFiles = showHiddenFiles == null ? false : showHiddenFiles;
            fileId = this.getFilePath(fileId);
            ProjectFile file = projectService.getProjectFile(projectId, fileId);
            FileMetadata fileMetadata = this.getFileMetadata(file, showHiddenFiles, locale);
            return Response.ok().entity((Object)fileMetadata).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdFolderPost(String projectId, String fileId, String name, String locale, SecurityContext securityContext) {
        try {
            ProjectFile targetFolder;
            if (!ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)fileId))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.invalid.file.path", new String[0]));
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            fileId = this.getFilePath(fileId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.info", new String[]{projectId}));
            if (name == null || name.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.name.empty", new String[0]));
            }
            try {
                targetFolder = projectService.getProjectFile(projectId, fileId);
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            if (!targetFolder.isDirectory().booleanValue()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.target.invalid", new String[0]));
            }
            if (targetFolder.containsChild(name)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.name.invalid", new String[]{name}));
            }
            ProjectFile newDirectory = projectService.createFolder(projectId, fileId, name);
            ibase.rest.model.project.v2.ProjectFile folder = this.buildRestProjectFile(newDirectory, true);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)folder).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsFileopsCopyPost(String sourceProjectId, String sourceFileId, String targetProjectId, String targetDirectoryId, String fileName, String locale, SecurityContext securityContext) {
        try {
            if (sourceProjectId == null || sourceProjectId.isEmpty() || sourceFileId == null || sourceFileId.isEmpty() || targetProjectId == null || targetProjectId.isEmpty() || targetDirectoryId == null || targetDirectoryId.isEmpty()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.copy.empty.parameters", new String[0]);
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            if (!ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)sourceFileId)) || !ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)targetDirectoryId))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.invalid.file.path", new String[0]));
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            sourceFileId = ROOT.equalsIgnoreCase(sourceFileId) ? "" : ServiceUtil.decodeFromBase64((String)sourceFileId);
            targetDirectoryId = ROOT.equalsIgnoreCase(targetDirectoryId) ? "" : ServiceUtil.decodeFromBase64((String)targetDirectoryId);
            sourceProjectId = ServiceUtil.decodeFromBase64((String)sourceProjectId);
            targetProjectId = ServiceUtil.decodeFromBase64((String)targetProjectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.copy.info", new String[]{sourceProjectId, sourceFileId, targetProjectId, targetDirectoryId}));
            try {
                if (!projectService.existsProjectFile(sourceProjectId, sourceFileId)) {
                    return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.copy.source.not.found", new String[]{sourceProjectId, sourceFileId}));
                }
                if (!projectService.existsProjectFile(targetProjectId, targetDirectoryId)) {
                    return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.copy.target.not.found", new String[]{targetProjectId, targetDirectoryId}));
                }
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            ProjectFile source = projectService.getProjectFile(sourceProjectId, sourceFileId);
            String sourceName = source.getName();
            ProjectFile target = projectService.getProjectFile(targetProjectId, targetDirectoryId);
            if (!target.isDirectory().booleanValue()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.copy.target.not.folder", new String[]{targetProjectId, targetDirectoryId});
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            projectService.copyFile(sourceProjectId, sourceFileId, targetProjectId, targetDirectoryId, fileName);
            ProjectFile resultFile = target.getChild(sourceName);
            ibase.rest.model.project.v2.ProjectFile fileAfterCopy = this.buildRestProjectFile(resultFile, true);
            return Response.ok().entity((Object)fileAfterCopy).build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsFileopsMovePost(String sourceProjectId, String sourceFileId, String targetProjectId, String targetFileId, String locale, SecurityContext securityContext) {
        try {
            if (sourceProjectId == null || sourceProjectId.isEmpty() || sourceFileId == null || sourceFileId.isEmpty() || targetProjectId == null || targetProjectId.isEmpty() || targetFileId == null || targetFileId.isEmpty()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.move.empty.parameters", new String[0]);
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            if (!ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)sourceFileId)) || !ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)targetFileId))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.invalid.file.path", new String[0]));
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            sourceFileId = ROOT.equalsIgnoreCase(sourceFileId) ? "" : ServiceUtil.decodeFromBase64((String)sourceFileId);
            targetFileId = ROOT.equalsIgnoreCase(targetFileId) ? "" : ServiceUtil.decodeFromBase64((String)targetFileId);
            sourceProjectId = ServiceUtil.decodeFromBase64((String)sourceProjectId);
            targetProjectId = ServiceUtil.decodeFromBase64((String)targetProjectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.move.info", new String[]{sourceProjectId, sourceFileId, targetProjectId, targetFileId}));
            try {
                if (!projectService.existsProjectFile(sourceProjectId, sourceFileId)) {
                    return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.move.source.not.found", new String[]{sourceProjectId, sourceFileId}));
                }
                if (!projectService.existsProjectFile(targetProjectId, targetFileId)) {
                    return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.move.target.not.found", new String[]{targetProjectId, targetFileId}));
                }
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            ProjectFile source = projectService.getProjectFile(sourceProjectId, sourceFileId);
            String sourceName = source.getName();
            ProjectFile target = projectService.getProjectFile(targetProjectId, targetFileId);
            if (!target.isDirectory().booleanValue()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.move.target.not.folder", new String[]{targetProjectId, targetFileId});
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            if (target.containsChild(sourceName)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.name.invalid", new String[]{sourceName}));
            }
            projectService.moveFile(sourceProjectId, sourceFileId, targetProjectId, targetFileId);
            ProjectFile resultFile = target.getChild(sourceName);
            ibase.rest.model.project.v2.ProjectFile fileAfterMove = this.buildRestProjectFile(resultFile, true);
            return Response.ok().entity((Object)fileAfterMove).build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsFileopsRenamePost(String projectId, String fileId, String name, String locale, SecurityContext securityContext) {
        try {
            if (projectId == null || projectId.isEmpty() || fileId == null || fileId.isEmpty() || name == null || name.isEmpty()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.rename.empty.parameters", new String[0]);
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            if (!ProjectsApiServiceImpl.validFileId(ServiceUtil.decodeFromBase64((String)fileId)) || !ProjectsApiServiceImpl.validFileId(name)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.invalid.file.path", new String[0]));
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            fileId = ROOT.equalsIgnoreCase(fileId) ? "" : ServiceUtil.decodeFromBase64((String)fileId);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.rename.info", new String[]{projectId, fileId, name}));
            try {
                if (!projectService.existsProjectFile(projectId, fileId)) {
                    return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.rename.file.not.found", new String[]{fileId}));
                }
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            ProjectFile resultFile = projectService.renameFile(projectId, fileId, name);
            ibase.rest.model.project.v2.ProjectFile fileAfterMove = this.buildRestProjectFile(resultFile, true);
            return Response.ok().entity((Object)fileAfterMove).build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsFileopsCancelUploadPost(String uploadId, String locale, SecurityContext securityContext) throws ibase.common.v2.NotFoundException {
        try {
            ProjectFile file;
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            HashMap attributes = new HashMap();
            try {
                authenticationService.parserToken(uploadId, attributes);
            }
            catch (ParseException e) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.cancelupload.id.invalid", new String[0]));
            }
            String tempFileName = (String)attributes.get(ATTRIBUTE_TEMP_FILE_NAME);
            String receivedProjectId = (String)attributes.get(ATTRIBUTE_PROJECT_ID);
            String projectId = ServiceUtil.decodeFromBase64((String)receivedProjectId);
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            try {
                file = projectService.getProjectFile(projectId, tempFileName);
            }
            catch (PermissionException e) {
                return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
            }
            file.remove();
            return Response.ok().build();
        }
        catch (ibase.common.v2.NotFoundException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesLinkGet(String projectId, List<String> filesId, String zipName, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            if (filesId == null || filesId.size() == 0) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.download.multiple.empty.parameters", new String[0]));
            }
            if (zipName == null) {
                zipName = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.zip.name.default", new String[0]);
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            String files = "";
            for (String fileId : filesId) {
                if (!files.equals("")) {
                    files = files + ",";
                }
                projectService.getProjectFile(ServiceUtil.decodeFromBase64((String)projectId), this.getFilePath(fileId));
                files = files + fileId;
            }
            if (files.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.download.multiple.empty.parameters", new String[0]));
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zipName", zipName);
            attrs.put("fileId", this.compressString(files));
            attrs.put(ATTRIBUTE_PROJECT_ID, projectId);
            String userId = ServiceAdapter.getCurrentUser();
            String token = authenticationService.createToken(userId, attrs, new Date(System.currentTimeMillis() + 30000L));
            StringBuilder builder = new StringBuilder();
            builder.append(ServiceAdapter.getURI());
            builder.append("/links/download_multiple?token=");
            builder.append(token);
            SuccessfulGetFilesLink response = new SuccessfulGetFilesLink();
            response.setUrl(builder.toString());
            response.setFileName(zipName);
            response.setMimeType("application/zip");
            return Response.ok().entity((Object)response).build();
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesLinkPost(String projectId, List<String> filesId, String zipName, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            if (filesId == null || filesId.size() == 0) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.download.multiple.empty.parameters", new String[0]));
            }
            if (zipName == null) {
                zipName = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.zip.name.default", new String[0]);
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            String files = "";
            for (String fileId : filesId) {
                if (!files.equals("")) {
                    files = files + ",";
                }
                projectService.getProjectFile(ServiceUtil.decodeFromBase64((String)projectId), this.getFilePath(fileId));
                files = files + fileId;
            }
            if (files.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.download.multiple.empty.parameters", new String[0]));
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zipName", zipName);
            attrs.put("fileId", this.compressString(files));
            attrs.put(ATTRIBUTE_PROJECT_ID, projectId);
            String userId = ServiceAdapter.getCurrentUser();
            String token = authenticationService.createToken(userId, attrs, new Date(System.currentTimeMillis() + 30000L));
            StringBuilder builder = new StringBuilder();
            builder.append(ServiceAdapter.getURI());
            builder.append("/links/download_multiple?token=");
            builder.append(token);
            SuccessfulGetFilesLink response = new SuccessfulGetFilesLink();
            response.setUrl(builder.toString());
            response.setFileName(zipName);
            response.setMimeType("application/zip");
            return Response.ok().entity((Object)response).build();
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    private String compressString(String srcTxt) {
        try {
            ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
            GZIPOutputStream zos = new GZIPOutputStream(rstBao);
            zos.write(srcTxt.getBytes());
            zos.close();
            return new String(Base64.getEncoder().encode(rstBao.toByteArray()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesGet(List<String> files, String projectId, String zipName, final String locale, SecurityContext securityContext) {
        if (files == null || files.size() == 0) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.download.multiple.empty.parameters", new String[0]));
        }
        final ArrayList<ProjectFile> projectFiles = new ArrayList<ProjectFile>();
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            final AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            for (int i = 0; i < files.size(); ++i) {
                if (files.get(i).isEmpty()) continue;
                projectFiles.add(projectService.getProjectFile(projectId, ServiceUtil.decodeFromBase64((String)files.get(i))));
            }
            if (projectFiles.size() == 0) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.download.multiple.empty.parameters", new String[0]));
            }
            final String token = authenticationService.createToken(ServiceAdapter.getCurrentUser(), null, null);
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException {
                    try {
                        String userId = authenticationService.parserToken(token, null);
                        ServiceAdapter.setCurrentUser((String)userId);
                        ZipOutputStream zos = new ZipOutputStream(out);
                        ProjectsApiServiceImpl.this.zipFiles(projectFiles.toArray(new ProjectFile[projectFiles.size()]), zos, null);
                        zos.close();
                        out.flush();
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)ProjectsApiServiceImpl.this.getBundle(locale)).message("project.internal.server.error", new String[0]), t);
                        throw new InternalServerErrorException(t);
                    }
                }
            };
            String name = (zipName == null ? ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.zip.name.default", new String[0]) : zipName) + ".zip";
            return Response.ok((Object)output).type("application/zip").header("Content-Disposition", (Object)("filename=\"" + name + "\"")).build();
        }
        catch (ibase.common.v2.NotFoundException | PermissionException e) {
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    private void zipFiles(ProjectFile[] files, ZipOutputStream out, ProjectFile parent) throws IOException {
        byte[] tmpBuf = new byte[1024];
        for (ProjectFile file : files) {
            String name = null;
            if (parent == null) {
                name = "/" + file.getName();
            } else {
                String path = file.getId().substring(parent.getId().length());
                name = "/" + parent.getName() + path;
            }
            if (file.isDirectory().booleanValue()) {
                name = name + "/";
                ProjectFile[] dirContent = file.getChildren(false);
                if (dirContent.length > 0 && dirContent.length > 0) {
                    this.zipFiles(dirContent, out, parent != null ? parent : file);
                    continue;
                }
            }
            out.putNextEntry(new ZipEntry(name));
            if (!file.isDirectory().booleanValue()) {
                int len;
                InputStream in = file.getInputStream();
                while ((len = in.read(tmpBuf)) > 0) {
                    out.write(tmpBuf, 0, len);
                }
                in.close();
            }
            out.closeEntry();
            out.flush();
        }
    }

    protected static boolean validFileId(String fileId) {
        return !fileId.contains("..");
    }
}

