/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.wizard;

import java.awt.Container;
import java.util.HashSet;
import java.util.Set;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.StepListener;
import tecgraf.javautils.gui.wizard.WizardException;

public abstract class Step {
    private ConfirmOperation confirmOperation;
    private Set<StepListener> listeners = new HashSet<StepListener>();
    private Step previousStep;

    protected Step() {
        this(ConfirmOperation.NOTHING);
    }

    protected Step(ConfirmOperation confirmOperation) {
        this.setConfirmOperation(confirmOperation);
    }

    public final void addListener(StepListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(StepListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract boolean canClose();

    protected abstract boolean canCancel();

    protected abstract boolean canConfirm();

    protected abstract void enter(History var1) throws WizardException;

    protected abstract void exit(History var1);

    protected abstract String getConfirmActionName();

    protected abstract String getConfirmActionTooltip();

    protected abstract Container getContainer();

    protected abstract String getInstruction();

    protected abstract Class<? extends Step> getNext(History var1);

    protected abstract String getTitle();

    protected abstract boolean isReady();

    protected abstract void translate(History var1, Object var2);

    protected abstract boolean isTranslationCompleted(History var1);

    protected void close() throws WizardException {
    }

    protected void cancel() throws WizardException {
    }

    protected Object confirm(History history) throws WizardException {
        return null;
    }

    protected boolean canGoPrevious() {
        return this.hasPrevious();
    }

    protected boolean canGoNext(History history) {
        if (!this.isReady()) {
            return false;
        }
        return this.hasNext(history);
    }

    protected final ConfirmOperation getConfirmOperation() {
        return this.confirmOperation;
    }

    protected final Step getPrevious() {
        return this.previousStep;
    }

    protected final boolean hasNext(History history) {
        return this.getNext(history) != null;
    }

    protected final boolean hasPrevious() {
        return this.getPrevious() != null;
    }

    protected final void notifyChanged() {
        for (StepListener listener : this.listeners) {
            listener.wasChanged(this);
        }
    }

    protected final void setConfirmOperation(ConfirmOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("O par\u00e2metro operation n\u00e3o pode ser nulo.");
        }
        this.confirmOperation = operation;
    }

    final void setPrevious(Step previousStep) {
        this.previousStep = previousStep;
    }

    public static enum ConfirmOperation {
        NOTHING,
        GO_NEXT;

    }
}

