/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.Config;
import tecgraf.javautils.gui.EmptyIcon;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIResources;

public class GUIUtils {
    public static final Color DEFAULT_PANEL_BACKGROUND_COLOR = UIManager.getColor("Panel.background");
    public static final Color DEFAULT_DISABLED_TEXT_COLOR = UIManager.getColor("Label.disabledForeground");
    public static final Font DEFAULT_LABEL_PLAIN_FONT = UIManager.getFont("Label.font").deriveFont(0);

    public static final void trimImageButton(AbstractButton button) {
        if (button == null) {
            throw new IllegalArgumentException("button == null");
        }
        Icon icon = button.getIcon();
        if (icon == null) {
            throw new IllegalArgumentException("icon == null");
        }
        Dimension size = new Dimension(icon.getIconWidth() + Config.IMAGE_BUTTON_MARGIN, icon.getIconHeight() + Config.IMAGE_BUTTON_MARGIN);
        button.setPreferredSize(size);
        button.setMaximumSize(size);
        button.setMinimumSize(size);
    }

    public static JButton createImageButton(Icon icon) {
        JButton button = new JButton();
        button.setIcon(icon);
        GUIUtils.trimImageButton(button);
        return button;
    }

    public static Icon createEmptyIcon(int width, int height) {
        return new EmptyIcon(width, height);
    }

    public static final void addWithGridBagConstraints(Container container, Component component, GridBagConstraints constraints, int horizontalIndex, int verticalIndex, int colSpan, int rowSpan, int horizontalWeight, int verticalWeight) {
        if (container == null) {
            throw new IllegalArgumentException("container == null");
        }
        if (component == null) {
            throw new IllegalArgumentException("component == null");
        }
        if (constraints == null) {
            throw new IllegalArgumentException("constraints == null");
        }
        constraints.gridx = horizontalIndex;
        constraints.gridy = verticalIndex;
        constraints.gridwidth = colSpan;
        constraints.gridheight = rowSpan;
        constraints.weightx = horizontalWeight;
        constraints.weighty = verticalWeight;
        container.add(component, constraints);
    }

    public static final void matchPreferredSizes(JComponent ... components) throws IllegalArgumentException {
        int i;
        if (components == null) {
            throw new IllegalArgumentException("components == null");
        }
        Dimension maxSize = new Dimension(0, 0);
        for (i = 0; i < components.length; ++i) {
            if (components[i] == null) {
                throw new IllegalArgumentException("component[" + i + "] == null");
            }
            double maxHeigth = Math.max(maxSize.getHeight(), components[i].getPreferredSize().getHeight());
            double maxWidth = Math.max(maxSize.getWidth(), components[i].getPreferredSize().getWidth());
            maxSize.setSize(maxWidth, maxHeigth);
        }
        for (i = 0; i < components.length; ++i) {
            components[i].setPreferredSize(maxSize);
        }
    }

    public static void showErrorByButton(Window window, String msg, JButton button) throws IllegalArgumentException {
        if (msg == null || msg.equals("")) {
            throw new IllegalArgumentException("msg == " + msg);
        }
        if (button == null) {
            throw new IllegalArgumentException("button == null");
        }
        button.setIcon(GUIResources.LABEL_ERROR_ICON);
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(window, msg, LNG.get((String)"javautils.input.error.msg"), 0);
        button.requestFocus();
        button.setIcon(null);
    }

    public static void showErrorByTextField(Window window, String msg, JLabel label, JTextField field) {
        if (msg == null || msg.equals("")) {
            throw new IllegalArgumentException("msg == " + msg);
        }
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field == null");
        }
        label.setIcon(GUIResources.LABEL_ERROR_ICON);
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(window, msg, LNG.get((String)"javautils.input.error.msg"), 0);
        field.requestFocus();
        field.setSelectionStart(0);
        field.setSelectionEnd(field.getText().length());
        label.setIcon(null);
    }

    public static final JPanel createBasicGridPanel(JComponent[][] rows) {
        JPanel panel = new JPanel();
        GUIUtils.mountBasicGridPanel(panel, rows);
        return panel;
    }

    public static final void mountBasicGridPanel(JPanel panel, JComponent[][] rows) {
        panel.setLayout(new GridBagLayout());
        if (rows == null) {
            return;
        }
        int T = 12;
        int TI = 6;
        int L = 11;
        int B = 12;
        int R = 11;
        int numRows = rows.length;
        for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
            JComponent[] row = rows[rowNumber];
            if (row == null) continue;
            int numCols = row.length;
            for (int colNumber = 0; colNumber < numCols; ++colNumber) {
                JComponent cell = row[colNumber];
                if (cell == null) continue;
                GBC gbc = new GBC(colNumber, rowNumber);
                gbc = gbc.gridheight(1).gridwidth(1);
                gbc = gbc.west().weights(1.0, 0.0);
                gbc = numRows == 1 ? gbc.insets(12, 11, 12, 11) : (rowNumber == 0 ? gbc.insets(12, 11, 0, 11) : (rowNumber == numRows - 1 ? gbc.insets(6, 11, 12, 11) : gbc.insets(6, 11, 0, 11)));
                gbc = colNumber == 1 ? gbc.horizontal().weightx(100.0) : gbc.none().west();
                panel.add((Component)cell, gbc);
            }
        }
    }

    public static final void centerOnScreen(Window window) {
        GUIUtils.placeWindowAt(window, Position.CENTER_MIDDLE);
    }

    public static void centerWindow(Window window, Window refWindow) {
        Window parentWindow;
        for (parentWindow = refWindow; parentWindow != null && !parentWindow.isVisible(); parentWindow = parentWindow.getOwner()) {
        }
        Dimension size = null;
        Point local = null;
        if (parentWindow != null) {
            size = parentWindow.getSize();
            local = parentWindow.getLocationOnScreen();
            int x = size.width / 2 + local.x;
            int y = size.height / 2 + local.y;
            Dimension wsize = window.getSize();
            window.setLocation(x -= wsize.width / 2, y -= wsize.height / 2);
        } else {
            GUIUtils.centerOnScreen(window);
        }
    }

    public static final void placeWindowAt(Window window, Position pos) {
        int newY;
        int newX;
        if (window == null) {
            throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel posicionar uma janela nula.");
        }
        Dimension screenSize = GUIUtils.getScreenDimension();
        Dimension windowSize = window.getSize();
        switch (pos) {
            case RIGHT_BOTTOM: {
                newX = Math.max(screenSize.width - windowSize.width, 0);
                newY = Math.max(screenSize.height - windowSize.height, 0);
                break;
            }
            case RIGHT_MIDDLE: {
                newX = Math.max(screenSize.width - windowSize.width, 0);
                newY = Math.max((screenSize.height - windowSize.height) / 2, 0);
                break;
            }
            case RIGHT_TOP: {
                newX = Math.max(screenSize.width - windowSize.width, 0);
                newY = 0;
                break;
            }
            case CENTER_BOTTOM: {
                newX = Math.max((screenSize.width - windowSize.width) / 2, 0);
                newY = Math.max(screenSize.height - windowSize.height, 0);
                break;
            }
            case CENTER_MIDDLE: {
                newX = Math.max((screenSize.width - windowSize.width) / 2, 0);
                newY = Math.max((screenSize.height - windowSize.height) / 2, 0);
                break;
            }
            case CENTER_TOP: {
                newX = Math.max((screenSize.width - windowSize.width) / 2, 0);
                newY = 0;
                break;
            }
            case LEFT_BOTTOM: {
                newX = 0;
                newY = Math.max(screenSize.height - windowSize.height, 0);
                break;
            }
            case LEFT_MIDDLE: {
                newX = 0;
                newY = Math.max((screenSize.height - windowSize.height) / 2, 0);
                break;
            }
            case LEFT_TOP: {
                newX = 0;
                newY = 0;
                break;
            }
            default: {
                throw new RuntimeException("Posi\u00e7\u00e3o inv\u00e1lida: " + pos.name());
            }
        }
        window.setLocation(newX, newY);
    }

    public static final Dimension getScreenDimension() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Dimension screenSize = graphicsConfiguration.getBounds().getSize();
        return screenSize;
    }

    public static void translateSwingComponents(Locale locale, List<?> baseNameList) {
        Iterator<?> baseNameIterator = baseNameList.iterator();
        while (baseNameIterator.hasNext()) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle((String)baseNameIterator.next(), locale);
            Enumeration<String> e = resourceBundle.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                UIManager.put(key, resourceBundle.getString(key));
            }
        }
    }

    public static void applyUndoRedoActions(JTextComponent textcomp) {
        final UndoManager undoManager = new UndoManager();
        Document doc = textcomp.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undoManager.addEdit(evt.getEdit());
            }
        });
        textcomp.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textcomp.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    static ImageIcon createIcon(String iconDir, String iconFileName) {
        return new ImageIcon(GUIResources.class.getResource(FileUtils.joinPath((boolean)true, (char)'/', (String[])new String[]{Config.IMAGES_DIRECTORY, iconDir, iconFileName})));
    }

    public static enum Position {
        LEFT_TOP,
        LEFT_MIDDLE,
        LEFT_BOTTOM,
        CENTER_TOP,
        CENTER_MIDDLE,
        CENTER_BOTTOM,
        RIGHT_TOP,
        RIGHT_MIDDLE,
        RIGHT_BOTTOM;

    }
}

