/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.table.TreeTableModel;
import tecgraf.javautils.gui.table.TreeTableModelAdapter;

public class TreeTable
extends JTable {
    private JTree tree;
    private TreeTableModel treeModel;
    private TableModel tableModel;

    public TreeTable(TreeTableModel treeTableModel) {
        this.treeModel = treeTableModel;
        this.tree = this.createTree(this.treeModel);
        this.tableModel = this.createModelAdapter(this.tree, treeTableModel);
        super.setModel(this.tableModel);
        this.createSelectionSynchronizer();
        this.createMouseListenerProxy();
        this.setDefaultRenderer(TreeTableModel.class, this.createTreeTableCellRenderer(this.tree, treeTableModel));
        this.setShowGrid(true);
        this.setIntercellSpacing(new Dimension(1, 1));
    }

    protected TableCellRenderer createTreeTableCellRenderer(JTree tree, TreeTableModel treeTableModel) {
        return (TableCellRenderer)((Object)this.tree);
    }

    protected TableModel createModelAdapter(JTree jtree, TreeTableModel tableTreeModel) {
        return new TreeTableModelAdapter(jtree, tableTreeModel);
    }

    protected JTree createTree(TreeTableModel tableTreeModel) {
        return new TreeTableCellRenderer(this, tableTreeModel);
    }

    public JTree getTree() {
        return this.tree;
    }

    protected void createSelectionSynchronizer() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] rows = TreeTable.this.getSelectedRows();
                TreeTable.this.tree.setSelectionRows(rows);
            }
        });
    }

    protected void createMouseListenerProxy() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.copyEventToTree(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.copyEventToTree(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.copyEventToTree(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.copyEventToTree(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int rowNumber = TreeTable.this.rowAtPoint(p);
                ListSelectionModel model = TreeTable.this.getSelectionModel();
                if ((e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) && !model.isSelectedIndex(rowNumber)) {
                    model.setSelectionInterval(rowNumber, rowNumber);
                }
                this.copyEventToTree(e);
                int[] rows = TreeTable.this.getSelectedRows();
                TreeTable.this.tree.setSelectionRows(rows);
            }

            protected void copyEventToTree(MouseEvent e) {
                int column = TreeTable.this.columnAtPoint(e.getPoint());
                int modelColumn = TreeTable.this.convertColumnIndexToModel(column);
                if (column < 0 || modelColumn < 0) {
                    return;
                }
                if (TreeTable.this.tableModel.getColumnClass(modelColumn) == TreeTableModel.class) {
                    int xAdjustment = 0;
                    for (int i = 0; i < column; ++i) {
                        xAdjustment += TreeTable.this.getColumnModel().getColumn(i).getWidth();
                    }
                    MouseEvent newEvent = new MouseEvent(TreeTable.this.tree, e.getID(), e.getWhen(), e.getModifiers(), e.getX() - xAdjustment, e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    TreeTable.this.tree.dispatchEvent(newEvent);
                }
            }
        });
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private JTable treeTable;
        protected int visibleRow;

        public TreeTableCellRenderer(JTable treeTable2, TreeTableModel model) {
            super(model);
            this.treeTable = treeTable2;
            this.getSelectionModel().setSelectionMode(4);
            this.setRowHeight(this.getRowHeight() + 2);
            this.setDragEnabled(false);
            this.setComponentPopupMenu(null);
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (this.treeTable != null && this.treeTable.getRowHeight() != rowHeight) {
                    this.treeTable.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, this.treeTable.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

