/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.json;

import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.util.Arrays;
import java.util.Optional;

public enum JuJsonSchemaVersion {
    V7("http://json-schema.org/draft-07/schema", SpecVersion.VersionFlag.V7),
    V2019("http://json-schema.org/draft/2019-09/schema", SpecVersion.VersionFlag.V201909);

    private final String url;
    private final SpecVersion.VersionFlag versionFlag;

    private JuJsonSchemaVersion(String url, SpecVersion.VersionFlag versionFlag) {
        this.url = url;
        this.versionFlag = versionFlag;
    }

    public String getUrl() {
        return this.url;
    }

    public static JuJsonSchemaVersion fromUrl(String url) {
        JuJsonSchemaVersion[] values = JuJsonSchemaVersion.values();
        Optional<JuJsonSchemaVersion> versionOptional = Arrays.stream(values).filter(v -> v.url.equals(url)).findFirst();
        return versionOptional.isEmpty() ? null : versionOptional.get();
    }

    public JsonSchemaFactory createFactory() {
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)this.versionFlag);
        return factory;
    }

    public String toString() {
        return this.name() + " - " + this.url;
    }
}

