/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.mvc.core.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import tecgraf.javautils.mvc.core.controller.Controller;

public class ControllerManager {
    private static ControllerManager instance = null;
    private final ReentrantLock rootLock = new ReentrantLock();
    private final List<Controller<?>> rootControllers = new ArrayList();
    private final AtomicBoolean mockEnabled = new AtomicBoolean(false);

    public static ControllerManager getInstance() {
        if (instance == null) {
            instance = new ControllerManager();
        }
        return instance;
    }

    private ControllerManager() {
    }

    public List<Controller<?>> getRootControllers() {
        this.lock();
        try {
            List<Controller<?>> list = Collections.unmodifiableList(this.rootControllers);
            return list;
        }
        finally {
            this.unlock();
        }
    }

    final void addToRootControllers(Controller<?> controller) {
        this.lock();
        try {
            this.rootControllers.add(controller);
        }
        finally {
            this.unlock();
        }
    }

    final void removeFromRootControllers(Controller<?> controller) {
        this.lock();
        try {
            this.rootControllers.remove(controller);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Controller> E find(Class<E> clazz) {
        this.lock();
        try {
            for (Controller<?> rootController : this.rootControllers) {
                if (clazz.isAssignableFrom(rootController.getClass())) {
                    Controller controller = (Controller)clazz.cast(rootController);
                    return (E)controller;
                }
                E c = rootController.getDescendant(clazz);
                if (c == null) continue;
                Controller controller = (Controller)clazz.cast(c);
                return (E)controller;
            }
            Iterator<Controller<?>> iterator = null;
            return (E)iterator;
        }
        finally {
            this.unlock();
        }
    }

    public <E extends Controller> boolean exists(Class<E> clazz) {
        return this.find(clazz) != null;
    }

    final void lock() {
        this.rootLock.lock();
    }

    final void unlock() {
        this.rootLock.unlock();
    }

    public void freeAll() {
        ArrayList list = null;
        this.lock();
        try {
            list = new ArrayList(this.rootControllers);
        }
        finally {
            this.unlock();
        }
        list.forEach(Controller::free);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Controller> List<E> findAll(Class<E> clazz) {
        ArrayList<E> list = new ArrayList<E>();
        this.lock();
        try {
            for (Controller<?> rootController : this.rootControllers) {
                if (clazz.isAssignableFrom(rootController.getClass())) {
                    list.add(clazz.cast(rootController));
                }
                this.fetchChildren(rootController, list, clazz);
            }
        }
        finally {
            this.unlock();
        }
        return list;
    }

    <E extends Controller> void fetchChildren(Controller<?> parent, List<E> list, Class<E> clazz) {
        List<Controller<?>> children = parent.getChildren();
        children.stream().filter(child -> clazz.isAssignableFrom(child.getClass())).map(clazz::cast).forEach(list::add);
        children.forEach(child -> this.fetchChildren((Controller<?>)child, list, clazz));
    }

    public <E extends Controller> void freeAll(Class<E> clazz) {
        this.findAll(clazz).forEach(Controller::free);
    }

    public void setMockEnabled(boolean mockEnabled) {
        this.mockEnabled.set(mockEnabled);
    }

    public boolean isMockEnabled() {
        return this.mockEnabled.get();
    }
}

