/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.mvc.utils.window.fx;

import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import tecgraf.javautils.mvc.core.ui.UiLibrary;
import tecgraf.javautils.mvc.utils.window.common.IWindowBuilder;
import tecgraf.javautils.mvc.utils.window.common.IWindowUi;

public abstract class FxStageWindow<C extends Pane>
extends Stage
implements IWindowUi,
IWindowBuilder<C> {
    private final Pane internalPane = new StackPane();
    private final Scene scene;

    protected FxStageWindow() {
        this.registerCloseEvents();
        this.scene = new Scene((Parent)this.internalPane);
        this.setScene(this.scene);
    }

    protected boolean addCss(String urlDefiniton) {
        URL url = null;
        try {
            url = new URL(urlDefiniton);
            this.scene.getStylesheets().add((Object)url.toExternalForm());
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected final void registerCloseEvents() {
        Platform.setImplicitExit((boolean)false);
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                event.consume();
            }
        });
        this.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, (EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (FxStageWindow.this.getWindowCallbacks() != null && FxStageWindow.this.getWindowCallbacks().getRequestCloseCallback() != null) {
                    FxStageWindow.this.getWindowCallbacks().getRequestCloseCallback().action(FxStageWindow.this, null);
                }
            }
        });
    }

    @Override
    public UiLibrary getUiLibrary() {
        return UiLibrary.FX;
    }

    @Override
    public void closeWindow() {
        UiLibrary uiLibrary = this.getUiLibrary();
        uiLibrary.runWithProtection(() -> this.hide());
    }

    @Override
    public void openWindow() {
        this.getUiLibrary().runWithProtection(() -> {
            Pane windowContent = (Pane)this.getWindowContent();
            this.internalPane.getChildren().add((Object)windowContent);
            this.show();
        });
    }

    @Override
    public boolean isWindowOpened() {
        return this.isShowing();
    }
}

