/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.mvc.utils.window.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tecgraf.javautils.mvc.core.ui.UiLibrary;
import tecgraf.javautils.mvc.utils.window.common.IWindowBuilder;
import tecgraf.javautils.mvc.utils.window.common.IWindowUi;

public abstract class SwingFrameWindow<C extends JComponent>
extends JFrame
implements IWindowUi,
IWindowBuilder<C> {
    private final JPanel internalPanel = new JPanel();

    protected SwingFrameWindow() {
        this.add(this.internalPanel);
        this.internalPanel.setLayout(new BorderLayout());
        this.registerCloseEvents();
    }

    protected final void registerCloseEvents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SwingFrameWindow.this.getWindowCallbacks() != null && SwingFrameWindow.this.getWindowCallbacks().getRequestCloseCallback() != null) {
                    SwingFrameWindow.this.getWindowCallbacks().getRequestCloseCallback().action(SwingFrameWindow.this, null);
                }
            }
        });
    }

    @Override
    public final UiLibrary getUiLibrary() {
        return UiLibrary.SWING;
    }

    @Override
    public void closeWindow() {
        this.getUiLibrary().runWithProtection(() -> this.setVisible(false));
    }

    @Override
    public void openWindow() {
        this.getUiLibrary().runWithProtection(() -> {
            this.internalPanel.add((Component)this.getWindowContent(), "Center");
            this.setVisible(true);
        });
    }

    @Override
    public boolean isWindowOpened() {
        return this.isVisible();
    }
}

