/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.standard;

import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Route;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.exceptions.JuException;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;
import tecgraf.javautils.sparkserver.utils.JuSparkUtilities;

public class JuRoute<T>
implements Route {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JuIFunction<T> function;
    private final Class<T> responseClass;
    private final Class<?> containedClass;
    private boolean container;

    public JuRoute(JuIFunction<T> function, Class<T> responseClass) {
        this(function, responseClass, null);
    }

    public JuRoute(JuIFunction<T> function, Class<T> responseClass, Class<?> containedClass) {
        if (function == null) {
            throw new IllegalArgumentException("null function not allowed!");
        }
        this.function = function;
        this.responseClass = responseClass;
        this.container = List.class.isAssignableFrom(responseClass);
        this.containedClass = containedClass;
    }

    public final Class<T> getResponseClass() {
        return this.responseClass;
    }

    public Class<?> getContainedClass() {
        return this.containedClass;
    }

    public final boolean isContainer() {
        return this.container;
    }

    public final Object handle(Request request, Response response) throws Exception {
        String hashString = UUID.randomUUID().toString();
        try {
            this.logger.info(this.getLoggerId(">>", null, hashString, request.pathInfo()));
            T object = this.function.call(request, response);
            if (!this.responseClass.isInstance(object)) {
                String fmt = "route returned a bad object (expected class was %s, but found %s)";
                throw new Exception(String.format("route returned a bad object (expected class was %s, but found %s)", this.responseClass.getName(), object.getClass().getName()));
            }
            this.logger.info(this.getLoggerId("<<", 200, hashString, String.format("status %d", response.status())));
            return JuSparkUtilities.objectToJson(object);
        }
        catch (JuException e) {
            String err = e.getMessage();
            int statusCode = e.getStatusCode();
            this.logger.warn(this.getLoggerId("XX", statusCode, hashString, err));
            return JuResponseUtilities.setResponseAsText(response, statusCode, err);
        }
        catch (Throwable t) {
            String err = t.getMessage();
            int statusCode = 500;
            this.logger.error(this.getLoggerId("!!", 500, hashString, err), t);
            return JuResponseUtilities.setResponseAsText(response, 500, err);
        }
    }

    private String getLoggerId(String prefix, Integer statusCode, String hashString, String text) {
        if (statusCode == null) {
            return String.format("%s [%s]: %s", prefix, hashString, text);
        }
        return String.format("%s [%s] (%02d): %s", prefix, hashString, statusCode, text);
    }
}

