/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.categories;

import busexplorer.Application;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.categories.CategoryWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategory;

public class CategoryDeleteAction
extends OpenBusAction<CategoryWrapper> {
    public CategoryDeleteAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights() && this.getTablePanelComponent().getSelectedElements().size() == 1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                CategoryWrapper category = (CategoryWrapper)CategoryDeleteAction.this.getTablePanelComponent().getSelectedElement();
                EntityCategory ref = category.getDescriptor().ref;
                ref.remove();
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CategoryDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

