/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.entities;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.entities.EntityInputDialog;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategoryDesc;

public class EntityEditAction
extends OpenBusAction<EntityWrapper> {
    public EntityEditAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.EDIT;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<List<EntityCategoryDesc>> task = new BusExplorerTask<List<EntityCategoryDesc>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setResult(Application.login().admin.getCategories());
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    EntityInputDialog dialog = new EntityInputDialog(EntityEditAction.this.parentWindow, EntityEditAction.this.getTablePanelComponent(), (List)this.getResult());
                    dialog.showDialog();
                    EntityWrapper entity = (EntityWrapper)EntityEditAction.this.getTablePanelComponent().getSelectedElement();
                    dialog.setEditionMode(entity);
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

