/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.healing;

import busexplorer.ApplicationIcons;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.RefreshablePanel;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.healing.AuthorizationMissingOffer;
import busexplorer.panel.healing.AuthorizationMissingProvider;
import busexplorer.panel.healing.ConsumerMissingBasicInformation;
import busexplorer.panel.healing.IntegrationMissingBasicInformation;
import busexplorer.panel.healing.OfferMissingProvider;
import busexplorer.panel.healing.ProviderMissingAuthorizations;
import busexplorer.panel.healing.ProviderMissingBasicInformation;
import busexplorer.panel.healing.ProviderMissingBusQuery;
import busexplorer.panel.healing.ProviderMissingContracts;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.japura.gui.CollapsiblePanel;
import org.japura.gui.CollapsibleRootPanel;

public class ConsistencyReportPanel
extends RefreshablePanel {
    private static final String LOADING = "Loading";
    private static final String NO_ISSUES = "No issues";
    private static final String HAS_ISSUES = "Has issues";
    private final JPanel cards;
    private final CollapsibleRootPanel collapsibleRootPanel;
    private final LinkedHashMap<String, TablePanelComponent> uiComponents;
    private final JFrame parentWindow;

    public ConsistencyReportPanel(JFrame parentWindow) {
        super(new BorderLayout());
        this.parentWindow = parentWindow;
        JPanel header = new JPanel(new MigLayout("fill, flowy"));
        JLabel headingLabel = new JLabel(ApplicationIcons.ICON_HEALTHY_32);
        headingLabel.setText(this.getString("title"));
        header.add((Component)headingLabel, "growx, push");
        header.add((Component)new JSeparator(0), "grow");
        this.add((Component)header, "North");
        this.uiComponents = new LinkedHashMap();
        this.uiComponents.put(this.getString("label.integration.missing.basic"), new IntegrationMissingBasicInformation(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        this.uiComponents.put(this.getString("label.consumer.missing.basic"), new ConsumerMissingBasicInformation(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        this.uiComponents.put(this.getString("label.provider.missing.basic"), new ProviderMissingBasicInformation(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        this.uiComponents.put(this.getString("label.provider.missing.contracts"), new ProviderMissingContracts(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        this.uiComponents.put(this.getString("label.provider.missing.busquery"), new ProviderMissingBusQuery(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        this.uiComponents.put(this.getString("label.provider.missing.authorizations"), new ProviderMissingAuthorizations(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        this.uiComponents.put(this.getString("label.authorization.missing.provider"), new AuthorizationMissingProvider(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        this.uiComponents.put(this.getString("label.authorization.missing.offer"), new AuthorizationMissingOffer(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        this.uiComponents.put(this.getString("label.offer.missing.provider"), new OfferMissingProvider(parentWindow, this::discardCollapsiblePanel).buildTableComponent());
        ImageIcon imageIcon = ApplicationIcons.ICON_LOADING_32;
        JLabel iconLabel = new JLabel(imageIcon);
        imageIcon.setImageObserver(iconLabel);
        JPanel loadingPane = new JPanel();
        loadingPane.add(iconLabel);
        JLabel okayPane = new JLabel(this.getString("label.everything.okay"));
        okayPane.setIcon(ApplicationIcons.ICON_VALIDATE_16);
        okayPane.setHorizontalAlignment(0);
        this.collapsibleRootPanel = new CollapsibleRootPanel(CollapsibleRootPanel.FILL);
        this.collapsibleRootPanel.setBackground(null);
        JScrollPane scrollPane = new JScrollPane(this.collapsibleRootPanel);
        scrollPane.setMaximumSize(this.getSize());
        scrollPane.setViewportBorder(null);
        scrollPane.setBorder(null);
        scrollPane.getInsets().set(0, 0, 0, 0);
        this.cards = new JPanel(new CardLayout());
        this.cards.add((Component)loadingPane, LOADING);
        this.cards.add((Component)okayPane, NO_ISSUES);
        this.cards.add((Component)scrollPane, HAS_ISSUES);
        this.add((Component)this.cards, "Center");
        JPanel footer = new JPanel(new MigLayout("fill, flowy"));
        footer.add((Component)new JSeparator(0), "grow");
        JPanel refreshPanel = new JPanel(new MigLayout("align center"));
        JButton refreshButton = new JButton();
        refreshButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsistencyReportPanel.this.refresh(actionEvent);
            }
        });
        refreshButton.setText(Language.get(TablePanelComponent.class, "refresh"));
        refreshButton.setMnemonic(refreshButton.getText().charAt(0));
        refreshButton.setToolTipText(Language.get(TablePanelComponent.class, "refresh.tooltip"));
        refreshButton.setIcon(ApplicationIcons.ICON_REFRESH_16);
        refreshPanel.add(refreshButton);
        footer.add((Component)refreshPanel, "grow, push, pad 0");
        this.add((Component)footer, "South");
    }

    @Override
    public void refresh(final ActionEvent event) {
        final CardLayout cardLayoutManager = (CardLayout)this.cards.getLayout();
        final Set<Map.Entry<String, TablePanelComponent>> uiElements = this.uiComponents.entrySet();
        cardLayoutManager.show(this.cards, LOADING);
        new BusExplorerTask<Void>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                for (Map.Entry element : uiElements) {
                    ((TablePanelComponent)element.getValue()).refresh(event);
                    this.setProgressStatus(100 * i / uiElements.size());
                    ++i;
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    ConsistencyReportPanel.this.collapsibleRootPanel.removeAll();
                    uiElements.stream().forEach(entry -> {
                        TablePanelComponent tableComponent = (TablePanelComponent)entry.getValue();
                        tableComponent.setPreferredSize(new Dimension(400, 100));
                        if (!tableComponent.getElements().isEmpty()) {
                            CollapsiblePanel collapsible = new CollapsiblePanel((String)entry.getKey());
                            collapsible.getInsets().set(0, 10, 0, 10);
                            collapsible.add(tableComponent);
                            ConsistencyReportPanel.this.collapsibleRootPanel.add(collapsible);
                        }
                    });
                    if (ConsistencyReportPanel.this.collapsibleRootPanel.getCollapsiblePanels().isEmpty()) {
                        cardLayoutManager.show(ConsistencyReportPanel.this.cards, ConsistencyReportPanel.NO_ISSUES);
                    } else {
                        cardLayoutManager.show(ConsistencyReportPanel.this.cards, ConsistencyReportPanel.HAS_ISSUES);
                    }
                }
            }
        }.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0, true, false);
    }

    private String getString(String key) {
        return Language.get(this.getClass(), key);
    }

    private void discardCollapsiblePanel(TablePanelComponent component) {
        if (component == null || component.getParent() == null || component.getParent().getParent() == null || !(component.getParent().getParent() instanceof CollapsiblePanel)) {
            throw new IllegalStateException("argument given doesn't respect the component hierarchy expected for " + this.getClass().getSimpleName());
        }
        CollapsiblePanel collapsiblePane = (CollapsiblePanel)component.getParent().getParent();
        if (this.collapsibleRootPanel != null) {
            this.collapsibleRootPanel.remove(collapsiblePane);
            component.getParent().remove(component);
            this.collapsibleRootPanel.validate();
            this.collapsibleRootPanel.repaint();
            if (this.collapsibleRootPanel.getCollapsiblePanels().isEmpty()) {
                ((CardLayout)this.cards.getLayout()).show(this.cards, NO_ISSUES);
            }
        }
    }
}

