/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar.components;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.calendar.Calendar;
import org.japura.gui.calendar.CalendarComponent;
import org.japura.gui.calendar.CalendarComponentType;
import org.japura.gui.calendar.DayOfWeek;
import org.japura.gui.calendar.components.CalendarSlot;

public class DayOfMonthSlot
extends CalendarSlot
implements MouseListener {
    private static final long serialVersionUID = 2647751815341515373L;
    private int day;
    private int month;
    private int year;
    private boolean currentMonth;
    private boolean selected;

    public DayOfMonthSlot(Calendar calendar) {
        super(calendar, CalendarComponentType.DAY_MONTH);
        this.setBorder(this.buildBorder());
        this.addMouseListener(this);
        this.setFont(this.getCalendar().getPropertiesProvider().getDayOfMonthFont());
    }

    private Border buildBorder() {
        Insets margin = this.getCalendar().getPropertiesProvider().getDayOfMonthMargin();
        int t = margin.top;
        int l = margin.left;
        int b = margin.bottom;
        int r = margin.right;
        return BorderFactory.createEmptyBorder(t, l, b, r);
    }

    public void setDate(int day, int month, int year) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.setText(day + "");
    }

    @Override
    public Color getBackground() {
        Calendar calendar = this.getCalendar();
        if (calendar == null) {
            return super.getBackground();
        }
        return calendar.getPropertiesProvider().getBackground(this);
    }

    @Override
    public Color getForeground() {
        Calendar calendar = this.getCalendar();
        if (calendar == null) {
            return super.getForeground();
        }
        return calendar.getPropertiesProvider().getForeground(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Calendar calendar = this.getCalendar();
        if (!calendar.isEnabled()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            JPopupMenu pm;
            PopupMenuBuilder<CalendarComponent> pmb = calendar.getPopupMenuBuilder();
            if (pmb != null && (pm = pmb.buildPopupMenu(this)) != null) {
                pm.show(this, e.getX(), e.getY());
            }
            return;
        }
        if (!this.getCalendar().isDialogMode() && this.selected) {
            return;
        }
        long time = this.getDate().getTime();
        if (this.currentMonth && this.getCalendar().isDialogMode()) {
            this.getCalendar().disposeDialog(time);
        } else {
            this.getCalendar().setDate(time);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public DayOfWeek getDayOfWeek() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(1, this.year);
        gc.set(2, this.month);
        gc.set(5, this.day);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        int dow = gc.get(7);
        return DayOfWeek.getDayOfWeek(dow);
    }

    public Date getDate() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(1, this.year);
        gc.set(2, this.month);
        gc.set(5, this.day);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc.getTime();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isCurrentMonth() {
        return this.currentMonth;
    }

    public int getDay() {
        return this.day;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setCurrentMonth(boolean currentMonth) {
        this.currentMonth = currentMonth;
    }
}

