/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.table.DateRenderer;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.HeightRenderer;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.SortableTable;
import tecgraf.javautils.gui.table.TestUser;

public class ObjectTableModelSample {
    public static void main(String[] args) {
        JFrame frame = new JFrame("teste");
        frame.setDefaultCloseOperation(3);
        ArrayList<TestUser> rows = new ArrayList<TestUser>();
        rows.add(new TestUser("Jo\u00e3o", new Date(124123412L), new Double(1.8)));
        rows.add(new TestUser("Elisa", new Date(565124123412L), new Double(1.55)));
        rows.add(new TestUser("Fl\u00e1via", new Date(775124123412L), new Double(1.675)));
        DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

            @Override
            public String[] getColumnNames() {
                String[] colNames = new String[]{"Nome", "Data Nasc.", "Altura"};
                return colNames;
            }

            @Override
            public Class<?>[] getColumnClasses() {
                Class[] colClasses = new Class[]{String.class, Date.class, Double.class};
                return colClasses;
            }

            public Object[] getCellValues(Object row) {
                if (row == null) {
                    return new Object[]{"???"};
                }
                TestUser user = (TestUser)row;
                return new Object[]{user.getName(), user.getBirthdate(), user.getHeight()};
            }
        };
        ObjectTableModel m = new ObjectTableModel(rows, provider);
        SortableTable table = new SortableTable(m);
        table.setDefaultRenderer(Date.class, new DateRenderer());
        table.getColumnModel().getColumn(2).setCellRenderer(new HeightRenderer());
        table.setPreferredScrollableViewportSize(new Dimension(200, 200));
        table.adjustColumnWidth();
        frame.getContentPane().add(new JScrollPane(table));
        frame.pack();
        frame.setVisible(true);
    }
}

