/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import com.google.common.collect.ArrayListMultimap;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OfferRegistrySubscription;
import tecgraf.openbus.core.BusResource;
import tecgraf.openbus.core.OfferRegistryImpl;
import tecgraf.openbus.core.OfferRegistryObserverImpl;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistryObserver;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistryObserverSubscription;
import tecgraf.openbus.exception.OpenBusInternalException;

class OfferRegistrySubscriptionImpl
extends BusResource
implements OfferRegistrySubscription {
    final OfferRegistryObserverImpl observer;
    final OfferRegistryObserver proxy;
    private final ArrayListMultimap<String, String> properties;
    private final OfferRegistryImpl registry;
    private OfferRegistryObserverSubscription sub = null;
    private static final Logger logger = Logger.getLogger(OfferRegistrySubscriptionImpl.class.getName());

    protected OfferRegistrySubscriptionImpl(OfferRegistryImpl registry, OfferRegistryObserverImpl observer, OfferRegistryObserver proxy, ArrayListMultimap<String, String> properties) {
        this.registry = registry;
        this.observer = observer;
        this.proxy = proxy;
        this.properties = properties;
    }

    @Override
    public Connection connection() {
        return this.registry.connection();
    }

    @Override
    public boolean subscribed() throws ServiceFailure {
        while (true) {
            try {
                return this.subscribed(Integer.MAX_VALUE);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subscribed(long timeoutMillis) throws ServiceFailure, TimeoutException {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("O timeout deve ser positivo.");
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.sub == null && this.lastError == null && timeoutMillis >= 0L) {
                long initial = System.currentTimeMillis();
                this.checkLoggedOut();
                if (this.cancelled) {
                    return false;
                }
                try {
                    if (timeoutMillis > 0L) {
                        this.lock.wait(timeoutMillis);
                    }
                }
                catch (InterruptedException e) {
                    this.logInterruptError(logger, e);
                    Thread.currentThread().interrupt();
                    return false;
                }
                timeoutMillis -= System.currentTimeMillis() - initial;
            }
            this.checkLoggedOut();
            if (this.cancelled) {
                return false;
            }
            if (this.sub == null) {
                if (this.lastError == null) {
                    throw new TimeoutException("N\u00e3o foi poss\u00edvel verificar a subscri\u00e7\u00e3o ao registro de oferta no tempo especificado.");
                }
                try {
                    throw this.lastError;
                }
                catch (Error | RuntimeException | ServiceFailure e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new OpenBusInternalException("Exce\u00e7\u00e3o inesperada ao tentar realizar uma subscri\u00e7\u00e3o de registro de oferta. Por favor contacte o administrador do sistema e informe-o sobre este erro.", e);
                }
            }
            return true;
        }
    }

    @Override
    public ArrayListMultimap<String, String> properties() {
        return this.properties;
    }

    @Override
    public void remove() {
        this.cancel();
        this.registry.removeRegistrySubscription(this);
        this.removeSub();
    }

    @Override
    public tecgraf.openbus.OfferRegistryObserver observer() {
        return this.observer.observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(Exception error) {
        Object object = this.lock;
        synchronized (object) {
            this.sub = null;
            super.error(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loggedOut() {
        Object object = this.lock;
        synchronized (object) {
            super.loggedOut();
            this.removeSub();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sub(OfferRegistryObserverSubscription sub) {
        Object object = this.lock;
        synchronized (object) {
            this.sub = sub;
            this.lastError = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OfferRegistryObserverSubscription sub() {
        Object object = this.lock;
        synchronized (object) {
            return this.sub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSub() {
        Object object = this.lock;
        synchronized (object) {
            this.sub = null;
            this.lastError = null;
            this.lock.notifyAll();
        }
    }
}

