/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.UserException;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.core.CallerChainImpl;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.Credential;
import tecgraf.openbus.core.InterceptorImpl;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.Session;
import tecgraf.openbus.core.v2_0.credential.CredentialDataHelper;
import tecgraf.openbus.core.v2_1.OctetSeqHolder;
import tecgraf.openbus.core.v2_1.credential.CredentialData;
import tecgraf.openbus.core.v2_1.services.access_control.CallChain;
import tecgraf.openbus.core.v2_1.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.interceptors.CallChainInfo;
import tecgraf.openbus.interceptors.CallChainInfoHelper;
import tecgraf.openbus.security.Cryptography;

final class ServerRequestInterceptorImpl
extends InterceptorImpl
implements ServerRequestInterceptor {
    private static final Logger logger = Logger.getLogger(ServerRequestInterceptorImpl.class.getName());

    ServerRequestInterceptorImpl(String name, ORBMediator mediator) {
        super(name, mediator);
    }

    @Override
    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    private Credential retrieveCredential(ServerRequestInfo ri) {
        byte[] encodedCredential;
        ServiceContext requestServiceContext;
        try {
            requestServiceContext = ri.get_request_service_context(1112888065);
            encodedCredential = requestServiceContext.context_data;
            if (encodedCredential != null) {
                Any any = this.codec().decode_value(encodedCredential, tecgraf.openbus.core.v2_1.credential.CredentialDataHelper.type());
                CredentialData credential = tecgraf.openbus.core.v2_1.credential.CredentialDataHelper.extract(any);
                return new Credential(credential);
            }
        }
        catch (BAD_PARAM e) {
            switch (e.minor) {
                case 26: {
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        catch (FormatMismatch | TypeMismatch e) {
            String message = "Falha inesperada ao decodificar a credencial";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        try {
            requestServiceContext = ri.get_request_service_context(1112888064);
            encodedCredential = requestServiceContext.context_data;
            if (encodedCredential != null) {
                Any any = this.codec().decode_value(encodedCredential, CredentialDataHelper.type());
                tecgraf.openbus.core.v2_0.credential.CredentialData credential = CredentialDataHelper.extract(any);
                return new Credential(credential);
            }
        }
        catch (BAD_PARAM e) {
            switch (e.minor) {
                case 26: {
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        catch (FormatMismatch | TypeMismatch e) {
            String message = "Falha inesperada ao decodificar a credencial";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        String message = "Nenhuma credencial suportada encontrada";
        logger.info(message);
        throw new NO_PERMISSION(message, 1112888070, CompletionStatus.COMPLETED_NO);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void receive_request(ServerRequestInfo ri) {
        block5: {
            operation = ri.operation();
            ServerRequestInterceptorImpl.logger.finest(String.format("[in] receive_request: %s", new Object[]{operation}));
            requestId = ri.request_id();
            object_id = ri.object_id();
            context = this.context();
            credential = this.retrieveCredential(ri);
            busId = credential.bus;
            loginId = credential.login;
            conn = this.getConnForDispatch(context, busId, loginId, object_id, operation);
            if (!busId.equals(conn.busId())) ** GOTO lbl33
            context.currentConnection(conn);
            if (!this.validateLogin(conn, loginId, ri)) ** GOTO lbl31
            pubkey = new OctetSeqHolder();
            entity = this.getLoginInfo(conn, loginId, pubkey, ri);
            if (!this.validateCredential(credential, ri, conn)) ** GOTO lbl29
            if (!this.validateChain(credential, null, conn)) break block5;
            this.saveRequestInformations(credential, conn, ri);
            msg = "Recebendo chamada pelo barramento: login (%s) entidade (%s) opera\u00e7\u00e3o (%s) requestId (%d)";
            ServerRequestInterceptorImpl.logger.fine(String.format(msg, new Object[]{loginId, entity, operation, requestId}));
            ServerRequestInterceptorImpl.logger.finest(String.format("[out] receive_request: %s", new Object[]{operation}));
            return;
        }
        try {
            try {
                ServerRequestInterceptorImpl.logger.fine(String.format("Recebeu chamada com cadeia inv\u00e1lida: opera\u00e7\u00e3o (%s) requestId (%d)", new Object[]{operation, requestId}));
                throw new NO_PERMISSION(1112888065, CompletionStatus.COMPLETED_NO);
lbl29:
                // 1 sources

                this.doResetCredential(ri, conn, credential, pubkey.value);
                throw new NO_PERMISSION(1112888064, CompletionStatus.COMPLETED_NO);
lbl31:
                // 1 sources

                ServerRequestInterceptorImpl.logger.severe(String.format("Credencial com login inv\u00e1lido: opera\u00e7\u00e3o (%s) login (%s)", new Object[]{operation, loginId}));
                throw new NO_PERMISSION(1112888066, CompletionStatus.COMPLETED_NO);
lbl33:
                // 1 sources

                ServerRequestInterceptorImpl.logger.severe(String.format("Recebeu chamade de outro barramento: opera\u00e7\u00e3o (%s) login (%s) bus (%s)", new Object[]{operation, loginId, busId}));
                throw new NO_PERMISSION(1112888066, CompletionStatus.COMPLETED_NO);
            }
            catch (CryptographyException e) {
                message = "Falha ao criptografar com chave p\u00fablica";
                ServerRequestInterceptorImpl.logger.log(Level.SEVERE, message, e);
                throw new NO_PERMISSION(1112888069, CompletionStatus.COMPLETED_NO);
            }
        }
        catch (Throwable var13_14) {
            ServerRequestInterceptorImpl.logger.finest(String.format("[out] receive_request: %s", new Object[]{operation}));
            throw var13_14;
        }
    }

    private ConnectionImpl getConnForDispatch(OpenBusContextImpl context, String busId, String loginId, byte[] object_id, String operation) {
        ConnectionImpl conn = null;
        CallDispatchCallback onCallDispatch = context.onCallDispatch();
        if (onCallDispatch != null) {
            try {
                conn = (ConnectionImpl)onCallDispatch.dispatch(context, busId, loginId, object_id, operation);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Callback 'onCallDispatch' gerou um erro durante execu\u00e7\u00e3o.", e);
            }
        }
        if (conn == null) {
            conn = (ConnectionImpl)context.defaultConnection();
        }
        if (conn == null || conn.login() == null || !conn.busId().equals(busId)) {
            throw new NO_PERMISSION(1112888068, CompletionStatus.COMPLETED_NO);
        }
        return conn;
    }

    private void doResetCredential(ServerRequestInfo ri, ConnectionImpl conn, Credential credential, byte[] publicKey) throws CryptographyException {
        byte[] newSecret = this.newSecret();
        Cryptography crypto = Cryptography.getInstance();
        byte[] encriptedSecret = crypto.encrypt(newSecret, crypto.generateRSAPublicKeyFromX509EncodedKey(publicKey));
        int sessionId = conn.nextAvailableSessionId();
        Session.ServerSideSession newSession = new Session.ServerSideSession(sessionId, newSecret, credential.login);
        conn.cache.srvSessions.put(newSession.getSession(), newSession);
        LoginInfo login = conn.login();
        Credential.Reset reset = new Credential.Reset(login, sessionId, encriptedSecret, credential.legacy);
        try {
            ri.add_reply_service_context(reset.toServiceContext(this.orb(), this.codec()), false);
            logger.fine(String.format("Resetando a credencial: opera\u00e7\u00e3o (%s) requestId (%d)", ri.operation(), ri.request_id()));
        }
        catch (InvalidTypeForEncoding e) {
            String message = String.format("Falha ao codificar reset: opera\u00e7\u00e3o (%s) requestId (%d)", ri.operation(), ri.request_id());
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }

    private boolean validateLogin(ConnectionImpl conn, String loginId, ServerRequestInfo ri) {
        try {
            return conn.cache.logins.validateLogin(loginId);
        }
        catch (NO_PERMISSION e) {
            String operation = ri.operation();
            int requestId = ri.request_id();
            if (e.minor == 1112888319) {
                String message = "Erro ao validar o login. Conex\u00e3o dispatcher est\u00e1 deslogada. opera\u00e7\u00e3o (%s) requestId (%d)";
                logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                throw new NO_PERMISSION(1112888068, CompletionStatus.COMPLETED_NO);
            }
            String message = "Erro ao validar o login. opera\u00e7\u00e3o (%s) requestId (%d)";
            logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
            throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception e) {
            String message = "Erro ao validar o login.";
            logger.log(Level.SEVERE, message, e);
            throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
        }
    }

    private String getLoginInfo(ConnectionImpl conn, String loginId, OctetSeqHolder pubkey, ServerRequestInfo ri) {
        String operation = ri.operation();
        int requestId = ri.request_id();
        try {
            return conn.cache.logins.getLoginEntity(loginId, pubkey);
        }
        catch (InvalidLogins e) {
            String message = "Login verificado \u00e9 inv\u00e1lido. opera\u00e7\u00e3o (%s) requestId (%d)";
            logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
            throw new NO_PERMISSION(1112888066, CompletionStatus.COMPLETED_NO);
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                String message = "Erro ao verificar o login. Conex\u00e3o dispatcher est\u00e1 deslogada. opera\u00e7\u00e3o (%s) requestId (%d)";
                logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                throw new NO_PERMISSION(1112888068, CompletionStatus.COMPLETED_NO);
            }
            String message = "Erro ao verificar o login. opera\u00e7\u00e3o (%s) requestId (%d)";
            logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
            throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception e) {
            String message = "Erro ao verificar o login. opera\u00e7\u00e3o (%s) requestId (%d)";
            logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
            throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
        }
    }

    private boolean validateCredential(Credential credential, ServerRequestInfo ri, ConnectionImpl conn) {
        Session.ServerSideSession session = conn.cache.srvSessions.get(credential.session);
        if (session != null && session.getCaller().equals(credential.login)) {
            byte[] hash = this.generateCredentialDataHash(ri, session.getSecret(), credential.ticket, credential.legacy);
            if (Arrays.equals(hash, credential.hash) && session.checkTicket(credential.ticket)) {
                logger.finest(String.format("credencial v\u00e1lida: opera\u00e7\u00e3o (%s) requestId (%d) sess\u00e3o (%d) ticket (%d)", ri.operation(), ri.request_id(), session.getSession(), credential.ticket));
                return true;
            }
            logger.finest(String.format("Falha na valida\u00e7\u00e3o do hash da credencial: opera\u00e7\u00e3o (%s) requestId (%d)", ri.operation(), ri.request_id()));
        } else {
            logger.fine(String.format("Recebeu chamada sem sess\u00e3o associda: opera\u00e7\u00e3o (%s) requestId (%d)", ri.operation(), ri.request_id()));
        }
        return false;
    }

    private boolean validateChain(Credential credential, RSAPublicKey pubKey, ConnectionImpl conn) {
        Cryptography crypto = Cryptography.getInstance();
        if (pubKey == null) {
            pubKey = conn.getBusPublicKey();
        }
        if (credential.chain != null) {
            try {
                Credential.Chain chain = credential.decodeChain(this.codec());
                boolean verified = crypto.verifySignature(pubKey, chain.encoded(), chain.signature());
                if (verified && chain.bus.equals(credential.bus) && chain.target.equals(conn.login().entity) && chain.caller.id.equals(credential.login)) {
                    return true;
                }
            }
            catch (UserException e) {
                String message = "Falha inesperada ao decodificar a cadeia";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
            catch (CryptographyException e) {
                String message = "Falha inesperada ao verificar assinatura da cadeia.";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
        }
        return false;
    }

    private void saveRequestInformations(Credential credential, ConnectionImpl conn, ServerRequestInfo ri) {
        CallChainInfo chainInfo = new CallChainInfo();
        Credential.Chain chain = credential.chain;
        chainInfo.chain = chain.signedChain;
        chainInfo.legacy = credential.legacy;
        chainInfo.bus = credential.bus;
        chainInfo.legacy_chain = chain.signedLegacy;
        if (!credential.legacy.booleanValue() && conn.legacy() && conn.legacySupport().converter() != null) {
            CallChain callchain = new CallChain(chain.bus, chain.target, chain.originators, chain.caller);
            try {
                this.context().joinChain(new CallerChainImpl(callchain, chain.signedChain));
                chainInfo.legacy_chain = conn.legacySupport().converter().convertSignedChain();
            }
            catch (Exception e) {
                String err = String.format("Falha ao converter cadeia assinada: opera\u00e7\u00e3o (%s) requestId (%d)", ri.operation(), ri.request_id());
                logger.log(Level.SEVERE, err, e);
                throw new NO_PERMISSION(err, 1112888070, CompletionStatus.COMPLETED_NO);
            }
            finally {
                this.context().exitChain();
            }
        }
        Any any = this.orb().create_any();
        CallChainInfoHelper.insert(any, chainInfo);
        try {
            ri.set_slot(this.mediator().getSignedChainSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao armazenar dados em slot";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        this.setCurrentConnection(ri, conn);
    }

    @Override
    public void send_reply(ServerRequestInfo ri) {
        String operation = ri.operation();
        this.removeCurrentConnection(ri);
        Any any = this.orb().create_any();
        try {
            ri.set_slot(this.mediator().getSignedChainSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao limpar informa\u00e7\u00f5es nos slots";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        String msg = "Chamada atendida: opera\u00e7\u00e3o (%s) requestId (%d)";
        logger.fine(String.format(msg, operation, ri.request_id()));
    }

    @Override
    public void send_exception(ServerRequestInfo ri) {
    }

    @Override
    public void send_other(ServerRequestInfo ri) {
    }

    private byte[] newSecret() {
        int size = 16;
        byte[] secret = new byte[size];
        Random random = new Random();
        random.nextBytes(secret);
        return secret;
    }

    private void setCurrentConnection(ServerRequestInfo ri, ConnectionImpl conn) {
        try {
            int id = this.mediator().getUniqueId();
            Any any = this.orb().create_any();
            any.insert_long(id);
            OpenBusContextImpl context = this.mediator().getContext();
            ri.set_slot(context.getCurrentConnectionSlotId(), any);
            context.setConnectionById(id, conn);
            logger.finest(String.format("Salvando conex\u00e3o que realiza o dispatch: conex\u00e3o (%s) login (%s) opera\u00e7\u00e3o (%s) requestId (%s)", conn.connId(), conn.login().id, ri.operation(), ri.request_id()));
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }

    private void removeCurrentConnection(ServerRequestInfo ri) {
        try {
            OpenBusContextImpl context = this.mediator().getContext();
            Any slot = ri.get_slot(context.getCurrentConnectionSlotId());
            if (slot.type().kind().value() == 0) {
                String message = "BUG: Falha inesperada ao acessar o slot da conex\u00e3o corrente";
                logger.log(Level.SEVERE, message);
                throw new INTERNAL(message);
            }
            int id = slot.extract_long();
            context.setConnectionById(id, null);
            Any any = this.orb().create_any();
            ri.set_slot(context.getCurrentConnectionSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }
}

