/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.retry;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.omg.CORBA.NO_PERMISSION;

public class RetryContext {
    private volatile int count = 0;
    private final long delay;
    private final TimeUnit delayUnit;
    private volatile Throwable lastException = null;
    private Future future;

    public RetryContext() {
        this(1L, TimeUnit.SECONDS);
    }

    public RetryContext(long delay, TimeUnit unit) {
        this.delay = delay;
        this.delayUnit = unit;
    }

    public int getRetryCount() {
        return this.count;
    }

    public long getDelay() {
        return this.delay;
    }

    public TimeUnit getDelayUnit() {
        return this.delayUnit;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public boolean shouldRetry() {
        if (this.future == null) {
            return false;
        }
        if (this.future.isCancelled() || this.future.isDone()) {
            return false;
        }
        Throwable last = this.getLastException();
        return !(last instanceof NO_PERMISSION) || ((NO_PERMISSION)last).minor != 1112888319;
    }

    protected void incrementRetrys() {
        ++this.count;
    }

    protected void setLastException(Throwable ex) {
        this.lastException = ex;
    }

    void future(Future future) {
        this.future = future;
    }
}

