/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model;

import br.pucrio.tecgraf.soma.job.domain.model.Multiflow;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="replica", uniqueConstraints={@UniqueConstraint(name="multiflow_replica_uk", columnNames={"line_number", "multiflow_id"})})
public class Replica {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="replica_generator")
    @SequenceGenerator(name="replica_generator", sequenceName="public.replica_seq", allocationSize=1)
    @Column(name="id", updatable=false, nullable=false)
    private long id;
    @Column(name="line_number", nullable=false)
    private Integer lineNumber = null;
    @ManyToOne
    @JoinColumn(name="multiflow_id", foreignKey=@ForeignKey(name="replica_multiflow_fk"), nullable=false)
    private Multiflow multiflow = null;
    @OneToMany(mappedBy="replica", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<ReplicaJob> replicaJobs = new ArrayList<ReplicaJob>();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public Multiflow getMultiflow() {
        return this.multiflow;
    }

    public void setMultiflow(Multiflow multiflow) {
        this.multiflow = multiflow;
    }

    public List<ReplicaJob> getReplicaJobs() {
        return this.replicaJobs;
    }

    public void addReplicaJob(ReplicaJob replicaJob) {
        replicaJob.setReplica(this);
        this.replicaJobs.add(replicaJob);
    }
}

