package br.pucrio.tecgraf.soma.job.domain.model;

import java.io.Serializable;

import jakarta.persistence.*;

@Entity
@Table(name = "job_dependency")
public class JobDependency implements Serializable {
    // Identifier
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "job_dependency_generator")
    @SequenceGenerator(name = "job_dependency_generator", sequenceName = "public.job_dependency_seq", allocationSize = 1)
    @Column(name = "id", updatable = false, nullable = false)
    private long id;

    // The job that has dependency.
    @ManyToOne
    @JoinColumn(name = "job_string_id", referencedColumnName="job_id", nullable=false)
    private Job job;

    // The job that is the dependency, if job_dependency_raw is a valid job id.
    @ManyToOne
    @JoinColumn(name = "job_dependency_string_id", referencedColumnName="job_id", nullable=true)
    private Job jobDependency;

    // The text that generated job dependency.
    @Column(name="job_dependency_raw", columnDefinition = "VARCHAR", nullable=false)
    private String jobDependencyRaw;

    public JobDependency() {
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Job getJob() {
        return job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public Job getJobDependency() {
        return jobDependency;
    }

    public void setJobDependency(Job jobDependency) {
        this.jobDependency = jobDependency;
    }

    public String getJobDependencyRaw() {
        return jobDependencyRaw;
    }

    public void setJobDependencyRaw(String jobDependencyRaw) {
        this.jobDependencyRaw = jobDependencyRaw;
    }

    public boolean isValid() {
        return this.jobDependency != null;
    }

    @Override
    public String toString() {
        return this.jobDependencyRaw;
    }
}
